/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;

public final class BatchGetItemPaginator
implements SdkIterable<BatchGetItemResponse> {
    private final DynamoDBClient client;
    private final BatchGetItemRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public BatchGetItemPaginator(DynamoDBClient client, BatchGetItemRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new BatchGetItemResponseFetcher();
    }

    public Iterator<BatchGetItemResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Map.Entry<String, List<Map<String, AttributeValue>>>> responses() {
        Function<BatchGetItemResponse, Iterator> getIterator = response -> response != null ? response.responses().entrySet().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class BatchGetItemResponseFetcher
    implements NextPageFetcher<BatchGetItemResponse> {
        private BatchGetItemResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetItemResponse previousPage) {
            return previousPage.unprocessedKeys() != null;
        }

        public BatchGetItemResponse nextPage(BatchGetItemResponse previousPage) {
            if (previousPage == null) {
                return BatchGetItemPaginator.this.client.batchGetItem(BatchGetItemPaginator.this.firstRequest);
            }
            return BatchGetItemPaginator.this.client.batchGetItem((BatchGetItemRequest)((Object)BatchGetItemPaginator.this.firstRequest.toBuilder().requestItems(previousPage.unprocessedKeys()).build()));
        }
    }
}

