/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;

public final class ListTablesPaginator
implements SdkIterable<ListTablesResponse> {
    private final DynamoDBClient client;
    private final ListTablesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListTablesPaginator(DynamoDBClient client, ListTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTablesResponseFetcher();
    }

    public Iterator<ListTablesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> tableNames() {
        Function<ListTablesResponse, Iterator> getIterator = response -> response != null ? response.tableNames().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListTablesResponseFetcher
    implements NextPageFetcher<ListTablesResponse> {
        private ListTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListTablesResponse previousPage) {
            return previousPage.lastEvaluatedTableName() != null;
        }

        public ListTablesResponse nextPage(ListTablesResponse previousPage) {
            if (previousPage == null) {
                return ListTablesPaginator.this.client.listTables(ListTablesPaginator.this.firstRequest);
            }
            return ListTablesPaginator.this.client.listTables((ListTablesRequest)((Object)ListTablesPaginator.this.firstRequest.toBuilder().exclusiveStartTableName(previousPage.lastEvaluatedTableName()).build()));
        }
    }
}

