/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueListCopier;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.transform.ConditionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Condition
implements StructuredPojo,
ToCopyableBuilder<Builder, Condition> {
    private final List<AttributeValue> attributeValueList;
    private final String comparisonOperator;

    private Condition(BuilderImpl builder) {
        this.attributeValueList = builder.attributeValueList;
        this.comparisonOperator = builder.comparisonOperator;
    }

    public List<AttributeValue> attributeValueList() {
        return this.attributeValueList;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorString() {
        return this.comparisonOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValueList());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        return Objects.equals(this.attributeValueList(), other.attributeValueList()) && Objects.equals(this.comparisonOperatorString(), other.comparisonOperatorString());
    }

    public String toString() {
        return ToString.builder((String)"Condition").add("AttributeValueList", this.attributeValueList()).add("ComparisonOperator", (Object)this.comparisonOperatorString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeValueList": {
                return Optional.of(clazz.cast(this.attributeValueList()));
            }
            case "ComparisonOperator": {
                return Optional.of(clazz.cast(this.comparisonOperatorString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeValue> attributeValueList;
        private String comparisonOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            this.attributeValueList(model.attributeValueList);
            this.comparisonOperator(model.comparisonOperator);
        }

        public final Collection<AttributeValue.Builder> getAttributeValueList() {
            return this.attributeValueList != null ? (Collection)this.attributeValueList.stream().map(AttributeValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeValueList(Collection<AttributeValue> attributeValueList) {
            this.attributeValueList = AttributeValueListCopier.copy(attributeValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValueList(AttributeValue ... attributeValueList) {
            this.attributeValueList(Arrays.asList(attributeValueList));
            return this;
        }

        public final void setAttributeValueList(Collection<AttributeValue.BuilderImpl> attributeValueList) {
            this.attributeValueList = AttributeValueListCopier.copyFromBuilder(attributeValueList);
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public Condition build() {
            return new Condition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Condition> {
        public Builder attributeValueList(Collection<AttributeValue> var1);

        public Builder attributeValueList(AttributeValue ... var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);
    }
}

