/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBStreamsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStreamsRequest
extends DynamoDBStreamsRequest
implements ToCopyableBuilder<Builder, ListStreamsRequest> {
    private final String tableName;
    private final Integer limit;
    private final String exclusiveStartStreamArn;

    private ListStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.limit = builder.limit;
        this.exclusiveStartStreamArn = builder.exclusiveStartStreamArn;
    }

    public String tableName() {
        return this.tableName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartStreamArn() {
        return this.exclusiveStartStreamArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartStreamArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsRequest)) {
            return false;
        }
        ListStreamsRequest other = (ListStreamsRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartStreamArn(), other.exclusiveStartStreamArn());
    }

    public String toString() {
        return ToString.builder((String)"ListStreamsRequest").add("TableName", (Object)this.tableName()).add("Limit", (Object)this.limit()).add("ExclusiveStartStreamArn", (Object)this.exclusiveStartStreamArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "ExclusiveStartStreamArn": {
                return Optional.of(clazz.cast(this.exclusiveStartStreamArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDBStreamsRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private Integer limit;
        private String exclusiveStartStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsRequest model) {
            this.tableName(model.tableName);
            this.limit(model.limit);
            this.exclusiveStartStreamArn(model.exclusiveStartStreamArn);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartStreamArn() {
            return this.exclusiveStartStreamArn;
        }

        @Override
        public final Builder exclusiveStartStreamArn(String exclusiveStartStreamArn) {
            this.exclusiveStartStreamArn = exclusiveStartStreamArn;
            return this;
        }

        public final void setExclusiveStartStreamArn(String exclusiveStartStreamArn) {
            this.exclusiveStartStreamArn = exclusiveStartStreamArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListStreamsRequest build() {
            return new ListStreamsRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDBStreamsRequest.Builder,
    CopyableBuilder<Builder, ListStreamsRequest> {
        public Builder tableName(String var1);

        public Builder limit(Integer var1);

        public Builder exclusiveStartStreamArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

