/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;

public class BatchGetItemIterable
implements SdkIterable<BatchGetItemResponse> {
    private final DynamoDBClient client;
    private final BatchGetItemRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public BatchGetItemIterable(DynamoDBClient client, BatchGetItemRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new BatchGetItemResponseFetcher();
    }

    public Iterator<BatchGetItemResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Map.Entry<String, List<Map<String, AttributeValue>>>> responses() {
        Function<BatchGetItemResponse, Iterator> getIterator = response -> {
            if (response != null && response.responses() != null) {
                return response.responses().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final BatchGetItemIterable resume(BatchGetItemResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new BatchGetItemIterable(this.client, (BatchGetItemRequest)((Object)this.firstRequest.toBuilder().requestItems(lastSuccessfulPage.unprocessedKeys()).build()));
        }
        return new BatchGetItemIterable(this.client, this.firstRequest){

            @Override
            public Iterator<BatchGetItemResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class BatchGetItemResponseFetcher
    implements SyncPageFetcher<BatchGetItemResponse> {
        private BatchGetItemResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetItemResponse previousPage) {
            return previousPage.unprocessedKeys() != null;
        }

        public BatchGetItemResponse nextPage(BatchGetItemResponse previousPage) {
            if (previousPage == null) {
                return BatchGetItemIterable.this.client.batchGetItem(BatchGetItemIterable.this.firstRequest);
            }
            return BatchGetItemIterable.this.client.batchGetItem((BatchGetItemRequest)((Object)BatchGetItemIterable.this.firstRequest.toBuilder().requestItems(previousPage.unprocessedKeys()).build()));
        }
    }
}

