/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class ScanIterable
implements SdkIterable<ScanResponse> {
    private final DynamoDBClient client;
    private final ScanRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ScanIterable(DynamoDBClient client, ScanRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ScanResponseFetcher();
    }

    public Iterator<ScanResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Map<String, AttributeValue>> items() {
        Function<ScanResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ScanIterable resume(ScanResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ScanIterable(this.client, (ScanRequest)((Object)this.firstRequest.toBuilder().exclusiveStartKey(lastSuccessfulPage.lastEvaluatedKey()).build()));
        }
        return new ScanIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ScanResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ScanResponseFetcher
    implements SyncPageFetcher<ScanResponse> {
        private ScanResponseFetcher() {
        }

        public boolean hasNextPage(ScanResponse previousPage) {
            return previousPage.lastEvaluatedKey() != null;
        }

        public ScanResponse nextPage(ScanResponse previousPage) {
            if (previousPage == null) {
                return ScanIterable.this.client.scan(ScanIterable.this.firstRequest);
            }
            return ScanIterable.this.client.scan((ScanRequest)((Object)ScanIterable.this.firstRequest.toBuilder().exclusiveStartKey(previousPage.lastEvaluatedKey()).build()));
        }
    }
}

