/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.dynamodb.DynamoDBAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class ScanPublisher
implements SdkPublisher<ScanResponse> {
    private final DynamoDBAsyncClient client;
    private final ScanRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ScanPublisher(DynamoDBAsyncClient client, ScanRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ScanPublisher(DynamoDBAsyncClient client, ScanRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ScanResponseFetcher();
    }

    public void subscribe(Subscriber<? super ScanResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Map<String, AttributeValue>> items() {
        Function<ScanResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ScanResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ScanPublisher resume(ScanResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ScanPublisher(this.client, (ScanRequest)((Object)this.firstRequest.toBuilder().exclusiveStartKey(lastSuccessfulPage.lastEvaluatedKey()).build()));
        }
        return new ScanPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ScanResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ScanResponseFetcher
    implements AsyncPageFetcher<ScanResponse> {
        private ScanResponseFetcher() {
        }

        public boolean hasNextPage(ScanResponse previousPage) {
            return previousPage.lastEvaluatedKey() != null;
        }

        public CompletableFuture<ScanResponse> nextPage(ScanResponse previousPage) {
            if (previousPage == null) {
                return ScanPublisher.this.client.scan(ScanPublisher.this.firstRequest);
            }
            return ScanPublisher.this.client.scan((ScanRequest)((Object)ScanPublisher.this.firstRequest.toBuilder().exclusiveStartKey(previousPage.lastEvaluatedKey()).build()));
        }
    }
}

