/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchWriteItemRequestModelMarshaller {
    private static final MarshallingInfo<Map> REQUESTITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestItems").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNCONSUMEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnConsumedCapacity").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNITEMCOLLECTIONMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnItemCollectionMetrics").isBinary(false).build();
    private static final BatchWriteItemRequestModelMarshaller INSTANCE = new BatchWriteItemRequestModelMarshaller();

    private BatchWriteItemRequestModelMarshaller() {
    }

    public static BatchWriteItemRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchWriteItemRequest batchWriteItemRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchWriteItemRequest), (String)"batchWriteItemRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchWriteItemRequest.requestItems(), REQUESTITEMS_BINDING);
            protocolMarshaller.marshall((Object)batchWriteItemRequest.returnConsumedCapacityString(), RETURNCONSUMEDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)batchWriteItemRequest.returnItemCollectionMetricsString(), RETURNITEMCOLLECTIONMETRICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

