/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.WriteRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an operation to perform - either <code>DeleteItem</code> or <code>PutItem</code>. You can only request one
 * of these operations, not both, in a single <code>WriteRequest</code>. If you do need to perform both of these
 * operations, you will need to provide two separate <code>WriteRequest</code> objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteRequest implements StructuredPojo, ToCopyableBuilder<WriteRequest.Builder, WriteRequest> {
    private final PutRequest putRequest;

    private final DeleteRequest deleteRequest;

    private WriteRequest(BuilderImpl builder) {
        this.putRequest = builder.putRequest;
        this.deleteRequest = builder.deleteRequest;
    }

    /**
     * <p>
     * A request to perform a <code>PutItem</code> operation.
     * </p>
     * 
     * @return A request to perform a <code>PutItem</code> operation.
     */
    public PutRequest putRequest() {
        return putRequest;
    }

    /**
     * <p>
     * A request to perform a <code>DeleteItem</code> operation.
     * </p>
     * 
     * @return A request to perform a <code>DeleteItem</code> operation.
     */
    public DeleteRequest deleteRequest() {
        return deleteRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(putRequest());
        hashCode = 31 * hashCode + Objects.hashCode(deleteRequest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteRequest)) {
            return false;
        }
        WriteRequest other = (WriteRequest) obj;
        return Objects.equals(putRequest(), other.putRequest()) && Objects.equals(deleteRequest(), other.deleteRequest());
    }

    @Override
    public String toString() {
        return ToString.builder("WriteRequest").add("PutRequest", putRequest()).add("DeleteRequest", deleteRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PutRequest":
            return Optional.ofNullable(clazz.cast(putRequest()));
        case "DeleteRequest":
            return Optional.ofNullable(clazz.cast(deleteRequest()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WriteRequest> {
        /**
         * <p>
         * A request to perform a <code>PutItem</code> operation.
         * </p>
         * 
         * @param putRequest
         *        A request to perform a <code>PutItem</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder putRequest(PutRequest putRequest);

        /**
         * <p>
         * A request to perform a <code>PutItem</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link PutRequest.Builder} avoiding the need to create
         * one manually via {@link PutRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link PutRequest.Builder#build()} is called immediately and its result
         * is passed to {@link #putRequest(PutRequest)}.
         * 
         * @param putRequest
         *        a consumer that will call methods on {@link PutRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #putRequest(PutRequest)
         */
        default Builder putRequest(Consumer<PutRequest.Builder> putRequest) {
            return putRequest(PutRequest.builder().applyMutation(putRequest).build());
        }

        /**
         * <p>
         * A request to perform a <code>DeleteItem</code> operation.
         * </p>
         * 
         * @param deleteRequest
         *        A request to perform a <code>DeleteItem</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteRequest(DeleteRequest deleteRequest);

        /**
         * <p>
         * A request to perform a <code>DeleteItem</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link DeleteRequest.Builder} avoiding the need to
         * create one manually via {@link DeleteRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #deleteRequest(DeleteRequest)}.
         * 
         * @param deleteRequest
         *        a consumer that will call methods on {@link DeleteRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteRequest(DeleteRequest)
         */
        default Builder deleteRequest(Consumer<DeleteRequest.Builder> deleteRequest) {
            return deleteRequest(DeleteRequest.builder().applyMutation(deleteRequest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PutRequest putRequest;

        private DeleteRequest deleteRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteRequest model) {
            putRequest(model.putRequest);
            deleteRequest(model.deleteRequest);
        }

        public final PutRequest.Builder getPutRequest() {
            return putRequest != null ? putRequest.toBuilder() : null;
        }

        @Override
        public final Builder putRequest(PutRequest putRequest) {
            this.putRequest = putRequest;
            return this;
        }

        public final void setPutRequest(PutRequest.BuilderImpl putRequest) {
            this.putRequest = putRequest != null ? putRequest.build() : null;
        }

        public final DeleteRequest.Builder getDeleteRequest() {
            return deleteRequest != null ? deleteRequest.toBuilder() : null;
        }

        @Override
        public final Builder deleteRequest(DeleteRequest deleteRequest) {
            this.deleteRequest = deleteRequest;
            return this;
        }

        public final void setDeleteRequest(DeleteRequest.BuilderImpl deleteRequest) {
            this.deleteRequest = deleteRequest != null ? deleteRequest.build() : null;
        }

        @Override
        public WriteRequest build() {
            return new WriteRequest(this);
        }
    }
}
