/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an <code>UpdateTable</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateTableRequest.Builder, UpdateTableRequest> {
    private final List<AttributeDefinition> attributeDefinitions;

    private final String tableName;

    private final ProvisionedThroughput provisionedThroughput;

    private final List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;

    private final StreamSpecification streamSpecification;

    private UpdateTableRequest(BuilderImpl builder) {
        super(builder);
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.globalSecondaryIndexUpdates = builder.globalSecondaryIndexUpdates;
        this.streamSpecification = builder.streamSpecification;
    }

    /**
     * <p>
     * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
     * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of attributes that describe the key schema for the table and indexes. If you are adding a new
     *         global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of
     *         the new index.
     */
    public List<AttributeDefinition> attributeDefinitions() {
        return attributeDefinitions;
    }

    /**
     * <p>
     * The name of the table to be updated.
     * </p>
     * 
     * @return The name of the table to be updated.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The new provisioned throughput settings for the specified table or index.
     * </p>
     * 
     * @return The new provisioned throughput settings for the specified table or index.
     */
    public ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * <p>
     * An array of one or more global secondary indexes for the table. For each index in the array, you can request one
     * action:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Create</code> - add a new global secondary index to the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Delete</code> - remove a global secondary index from the table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
     * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of one or more global secondary indexes for the table. For each index in the array, you can
     *         request one action:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Create</code> - add a new global secondary index to the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Delete</code> - remove a global secondary index from the table.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
     *         Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates() {
        return globalSecondaryIndexUpdates;
    }

    /**
     * <p>
     * Represents the DynamoDB Streams configuration for the table.
     * </p>
     * <note>
     * <p>
     * You will receive a <code>ResourceInUseException</code> if you attempt to enable a stream on a table that already
     * has a stream, or if you attempt to disable a stream on a table which does not have a stream.
     * </p>
     * </note>
     * 
     * @return Represents the DynamoDB Streams configuration for the table.</p> <note>
     *         <p>
     *         You will receive a <code>ResourceInUseException</code> if you attempt to enable a stream on a table that
     *         already has a stream, or if you attempt to disable a stream on a table which does not have a stream.
     *         </p>
     */
    public StreamSpecification streamSpecification() {
        return streamSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(globalSecondaryIndexUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(streamSpecification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest) obj;
        return Objects.equals(attributeDefinitions(), other.attributeDefinitions())
                && Objects.equals(tableName(), other.tableName())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && Objects.equals(globalSecondaryIndexUpdates(), other.globalSecondaryIndexUpdates())
                && Objects.equals(streamSpecification(), other.streamSpecification());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateTableRequest").add("AttributeDefinitions", attributeDefinitions())
                .add("TableName", tableName()).add("ProvisionedThroughput", provisionedThroughput())
                .add("GlobalSecondaryIndexUpdates", globalSecondaryIndexUpdates())
                .add("StreamSpecification", streamSpecification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeDefinitions":
            return Optional.ofNullable(clazz.cast(attributeDefinitions()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "GlobalSecondaryIndexUpdates":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexUpdates()));
        case "StreamSpecification":
            return Optional.ofNullable(clazz.cast(streamSpecification()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDbRequest.Builder, CopyableBuilder<Builder, UpdateTableRequest> {
        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
         * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new
         * index.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes. If you are adding a new
         *        global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s)
         *        of the new index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions);

        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
         * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new
         * index.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes. If you are adding a new
         *        global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s)
         *        of the new index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(AttributeDefinition... attributeDefinitions);

        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
         * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new
         * index.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<AttributeDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeDefinition>.Builder#build()} is called immediately
         * and its result is passed to {@link #attributeDefinitions(List<AttributeDefinition>)}.
         * 
         * @param attributeDefinitions
         *        a consumer that will call methods on {@link List<AttributeDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeDefinitions(List<AttributeDefinition>)
         */
        Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions);

        /**
         * <p>
         * The name of the table to be updated.
         * </p>
         * 
         * @param tableName
         *        The name of the table to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The new provisioned throughput settings for the specified table or index.
         * </p>
         * 
         * @param provisionedThroughput
         *        The new provisioned throughput settings for the specified table or index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * The new provisioned throughput settings for the specified table or index.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding the need
         * to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         * <p>
         * An array of one or more global secondary indexes for the table. For each index in the array, you can request
         * one action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Create</code> - add a new global secondary index to the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delete</code> - remove a global secondary index from the table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
         * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param globalSecondaryIndexUpdates
         *        An array of one or more global secondary indexes for the table. For each index in the array, you can
         *        request one action:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Create</code> - add a new global secondary index to the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Update</code> - modify the provisioned throughput settings of an existing global secondary
         *        index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Delete</code> - remove a global secondary index from the table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing
         *        Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates);

        /**
         * <p>
         * An array of one or more global secondary indexes for the table. For each index in the array, you can request
         * one action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Create</code> - add a new global secondary index to the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delete</code> - remove a global secondary index from the table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
         * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param globalSecondaryIndexUpdates
         *        An array of one or more global secondary indexes for the table. For each index in the array, you can
         *        request one action:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Create</code> - add a new global secondary index to the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Update</code> - modify the provisioned throughput settings of an existing global secondary
         *        index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Delete</code> - remove a global secondary index from the table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing
         *        Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate... globalSecondaryIndexUpdates);

        /**
         * <p>
         * An array of one or more global secondary indexes for the table. For each index in the array, you can request
         * one action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Create</code> - add a new global secondary index to the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delete</code> - remove a global secondary index from the table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
         * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GlobalSecondaryIndexUpdate>.Builder}
         * avoiding the need to create one manually via {@link List<GlobalSecondaryIndexUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlobalSecondaryIndexUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #globalSecondaryIndexUpdates(List<GlobalSecondaryIndexUpdate>)}.
         * 
         * @param globalSecondaryIndexUpdates
         *        a consumer that will call methods on {@link List<GlobalSecondaryIndexUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexUpdates(List<GlobalSecondaryIndexUpdate>)
         */
        Builder globalSecondaryIndexUpdates(Consumer<GlobalSecondaryIndexUpdate.Builder>... globalSecondaryIndexUpdates);

        /**
         * <p>
         * Represents the DynamoDB Streams configuration for the table.
         * </p>
         * <note>
         * <p>
         * You will receive a <code>ResourceInUseException</code> if you attempt to enable a stream on a table that
         * already has a stream, or if you attempt to disable a stream on a table which does not have a stream.
         * </p>
         * </note>
         * 
         * @param streamSpecification
         *        Represents the DynamoDB Streams configuration for the table.</p> <note>
         *        <p>
         *        You will receive a <code>ResourceInUseException</code> if you attempt to enable a stream on a table
         *        that already has a stream, or if you attempt to disable a stream on a table which does not have a
         *        stream.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSpecification(StreamSpecification streamSpecification);

        /**
         * <p>
         * Represents the DynamoDB Streams configuration for the table.
         * </p>
         * <note>
         * <p>
         * You will receive a <code>ResourceInUseException</code> if you attempt to enable a stream on a table that
         * already has a stream, or if you attempt to disable a stream on a table which does not have a stream.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link StreamSpecification.Builder} avoiding
         * the need to create one manually via {@link StreamSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #streamSpecification(StreamSpecification)}.
         * 
         * @param streamSpecification
         *        a consumer that will call methods on {@link StreamSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSpecification(StreamSpecification)
         */
        default Builder streamSpecification(Consumer<StreamSpecification.Builder> streamSpecification) {
            return streamSpecification(StreamSpecification.builder().applyMutation(streamSpecification).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private List<AttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String tableName;

        private ProvisionedThroughput provisionedThroughput;

        private List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates = DefaultSdkAutoConstructList.getInstance();

        private StreamSpecification streamSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            super(model);
            attributeDefinitions(model.attributeDefinitions);
            tableName(model.tableName);
            provisionedThroughput(model.provisionedThroughput);
            globalSecondaryIndexUpdates(model.globalSecondaryIndexUpdates);
            streamSpecification(model.streamSpecification);
        }

        public final Collection<AttributeDefinition.Builder> getAttributeDefinitions() {
            return attributeDefinitions != null ? attributeDefinitions.stream().map(AttributeDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition... attributeDefinitions) {
            attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions) {
            attributeDefinitions(Stream.of(attributeDefinitions).map(c -> AttributeDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final Collection<GlobalSecondaryIndexUpdate.Builder> getGlobalSecondaryIndexUpdates() {
            return globalSecondaryIndexUpdates != null ? globalSecondaryIndexUpdates.stream()
                    .map(GlobalSecondaryIndexUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copy(globalSecondaryIndexUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate... globalSecondaryIndexUpdates) {
            globalSecondaryIndexUpdates(Arrays.asList(globalSecondaryIndexUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(
                Consumer<GlobalSecondaryIndexUpdate.Builder>... globalSecondaryIndexUpdates) {
            globalSecondaryIndexUpdates(Stream.of(globalSecondaryIndexUpdates)
                    .map(c -> GlobalSecondaryIndexUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexUpdates(
                Collection<GlobalSecondaryIndexUpdate.BuilderImpl> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copyFromBuilder(globalSecondaryIndexUpdates);
        }

        public final StreamSpecification.Builder getStreamSpecification() {
            return streamSpecification != null ? streamSpecification.toBuilder() : null;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }
    }
}
