/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.services.dynamodb.transform.ReplicaGlobalSecondaryIndexSettingsDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaGlobalSecondaryIndexSettingsDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, ReplicaGlobalSecondaryIndexSettingsDescription> {
    private final String indexName;
    private final String indexStatus;
    private final Long provisionedReadCapacityUnits;
    private final Long provisionedWriteCapacityUnits;

    private ReplicaGlobalSecondaryIndexSettingsDescription(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.indexStatus = builder.indexStatus;
        this.provisionedReadCapacityUnits = builder.provisionedReadCapacityUnits;
        this.provisionedWriteCapacityUnits = builder.provisionedWriteCapacityUnits;
    }

    public String indexName() {
        return this.indexName;
    }

    public IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public String indexStatusAsString() {
        return this.indexStatus;
    }

    public Long provisionedReadCapacityUnits() {
        return this.provisionedReadCapacityUnits;
    }

    public Long provisionedWriteCapacityUnits() {
        return this.provisionedWriteCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedWriteCapacityUnits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaGlobalSecondaryIndexSettingsDescription)) {
            return false;
        }
        ReplicaGlobalSecondaryIndexSettingsDescription other = (ReplicaGlobalSecondaryIndexSettingsDescription)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(this.provisionedReadCapacityUnits(), other.provisionedReadCapacityUnits()) && Objects.equals(this.provisionedWriteCapacityUnits(), other.provisionedWriteCapacityUnits());
    }

    public String toString() {
        return ToString.builder((String)"ReplicaGlobalSecondaryIndexSettingsDescription").add("IndexName", (Object)this.indexName()).add("IndexStatus", (Object)this.indexStatusAsString()).add("ProvisionedReadCapacityUnits", (Object)this.provisionedReadCapacityUnits()).add("ProvisionedWriteCapacityUnits", (Object)this.provisionedWriteCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "ProvisionedReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.provisionedReadCapacityUnits()));
            }
            case "ProvisionedWriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.provisionedWriteCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicaGlobalSecondaryIndexSettingsDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private String indexStatus;
        private Long provisionedReadCapacityUnits;
        private Long provisionedWriteCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaGlobalSecondaryIndexSettingsDescription model) {
            this.indexName(model.indexName);
            this.indexStatus(model.indexStatus);
            this.provisionedReadCapacityUnits(model.provisionedReadCapacityUnits);
            this.provisionedWriteCapacityUnits(model.provisionedWriteCapacityUnits);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus.toString());
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        public final Long getProvisionedReadCapacityUnits() {
            return this.provisionedReadCapacityUnits;
        }

        @Override
        public final Builder provisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
            return this;
        }

        public final void setProvisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
        }

        public final Long getProvisionedWriteCapacityUnits() {
            return this.provisionedWriteCapacityUnits;
        }

        @Override
        public final Builder provisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
            return this;
        }

        public final void setProvisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
        }

        public ReplicaGlobalSecondaryIndexSettingsDescription build() {
            return new ReplicaGlobalSecondaryIndexSettingsDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReplicaGlobalSecondaryIndexSettingsDescription> {
        public Builder indexName(String var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder provisionedReadCapacityUnits(Long var1);

        public Builder provisionedWriteCapacityUnits(Long var1);
    }
}

