/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateGlobalTableRequestModelMarshaller {
    private static final MarshallingInfo<String> GLOBALTABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalTableName").isBinary(false).build();
    private static final MarshallingInfo<List> REPLICAUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicaUpdates").isBinary(false).build();
    private static final UpdateGlobalTableRequestModelMarshaller INSTANCE = new UpdateGlobalTableRequestModelMarshaller();

    private UpdateGlobalTableRequestModelMarshaller() {
    }

    public static UpdateGlobalTableRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateGlobalTableRequest updateGlobalTableRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateGlobalTableRequest), (String)"updateGlobalTableRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateGlobalTableRequest.globalTableName(), GLOBALTABLENAME_BINDING);
            protocolMarshaller.marshall(updateGlobalTableRequest.replicaUpdates(), REPLICAUPDATES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

