/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupsRequest extends DynamoDbRequest implements
        ToCopyableBuilder<ListBackupsRequest.Builder, ListBackupsRequest> {
    private final String tableName;

    private final Integer limit;

    private final Instant timeRangeLowerBound;

    private final Instant timeRangeUpperBound;

    private final String exclusiveStartBackupArn;

    private ListBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.limit = builder.limit;
        this.timeRangeLowerBound = builder.timeRangeLowerBound;
        this.timeRangeUpperBound = builder.timeRangeUpperBound;
        this.exclusiveStartBackupArn = builder.exclusiveStartBackupArn;
    }

    /**
     * <p>
     * The backups from the table specified by TableName are listed.
     * </p>
     * 
     * @return The backups from the table specified by TableName are listed.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Maximum number of backups to return at once.
     * </p>
     * 
     * @return Maximum number of backups to return at once.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.
     * </p>
     * 
     * @return Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.
     */
    public Instant timeRangeLowerBound() {
        return timeRangeLowerBound;
    }

    /**
     * <p>
     * Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive.
     * </p>
     * 
     * @return Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive.
     */
    public Instant timeRangeUpperBound() {
        return timeRangeUpperBound;
    }

    /**
     * <p>
     * <code>LastEvaluatedBackupARN</code> returned by the previous ListBackups call.
     * </p>
     * 
     * @return <code>LastEvaluatedBackupARN</code> returned by the previous ListBackups call.
     */
    public String exclusiveStartBackupArn() {
        return exclusiveStartBackupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeLowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeUpperBound());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartBackupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupsRequest)) {
            return false;
        }
        ListBackupsRequest other = (ListBackupsRequest) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(limit(), other.limit())
                && Objects.equals(timeRangeLowerBound(), other.timeRangeLowerBound())
                && Objects.equals(timeRangeUpperBound(), other.timeRangeUpperBound())
                && Objects.equals(exclusiveStartBackupArn(), other.exclusiveStartBackupArn());
    }

    @Override
    public String toString() {
        return ToString.builder("ListBackupsRequest").add("TableName", tableName()).add("Limit", limit())
                .add("TimeRangeLowerBound", timeRangeLowerBound()).add("TimeRangeUpperBound", timeRangeUpperBound())
                .add("ExclusiveStartBackupArn", exclusiveStartBackupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "TimeRangeLowerBound":
            return Optional.ofNullable(clazz.cast(timeRangeLowerBound()));
        case "TimeRangeUpperBound":
            return Optional.ofNullable(clazz.cast(timeRangeUpperBound()));
        case "ExclusiveStartBackupArn":
            return Optional.ofNullable(clazz.cast(exclusiveStartBackupArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDbRequest.Builder, CopyableBuilder<Builder, ListBackupsRequest> {
        /**
         * <p>
         * The backups from the table specified by TableName are listed.
         * </p>
         * 
         * @param tableName
         *        The backups from the table specified by TableName are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Maximum number of backups to return at once.
         * </p>
         * 
         * @param limit
         *        Maximum number of backups to return at once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.
         * </p>
         * 
         * @param timeRangeLowerBound
         *        Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRangeLowerBound(Instant timeRangeLowerBound);

        /**
         * <p>
         * Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive.
         * </p>
         * 
         * @param timeRangeUpperBound
         *        Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRangeUpperBound(Instant timeRangeUpperBound);

        /**
         * <p>
         * <code>LastEvaluatedBackupARN</code> returned by the previous ListBackups call.
         * </p>
         * 
         * @param exclusiveStartBackupArn
         *        <code>LastEvaluatedBackupARN</code> returned by the previous ListBackups call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartBackupArn(String exclusiveStartBackupArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableName;

        private Integer limit;

        private Instant timeRangeLowerBound;

        private Instant timeRangeUpperBound;

        private String exclusiveStartBackupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupsRequest model) {
            super(model);
            tableName(model.tableName);
            limit(model.limit);
            timeRangeLowerBound(model.timeRangeLowerBound);
            timeRangeUpperBound(model.timeRangeUpperBound);
            exclusiveStartBackupArn(model.exclusiveStartBackupArn);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Instant getTimeRangeLowerBound() {
            return timeRangeLowerBound;
        }

        @Override
        public final Builder timeRangeLowerBound(Instant timeRangeLowerBound) {
            this.timeRangeLowerBound = timeRangeLowerBound;
            return this;
        }

        public final void setTimeRangeLowerBound(Instant timeRangeLowerBound) {
            this.timeRangeLowerBound = timeRangeLowerBound;
        }

        public final Instant getTimeRangeUpperBound() {
            return timeRangeUpperBound;
        }

        @Override
        public final Builder timeRangeUpperBound(Instant timeRangeUpperBound) {
            this.timeRangeUpperBound = timeRangeUpperBound;
            return this;
        }

        public final void setTimeRangeUpperBound(Instant timeRangeUpperBound) {
            this.timeRangeUpperBound = timeRangeUpperBound;
        }

        public final String getExclusiveStartBackupArn() {
            return exclusiveStartBackupArn;
        }

        @Override
        public final Builder exclusiveStartBackupArn(String exclusiveStartBackupArn) {
            this.exclusiveStartBackupArn = exclusiveStartBackupArn;
            return this;
        }

        public final void setExclusiveStartBackupArn(String exclusiveStartBackupArn) {
            this.exclusiveStartBackupArn = exclusiveStartBackupArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBackupsRequest build() {
            return new ListBackupsRequest(this);
        }
    }
}
