/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGlobalTablesRequest extends DynamoDbRequest implements
        ToCopyableBuilder<ListGlobalTablesRequest.Builder, ListGlobalTablesRequest> {
    private final String exclusiveStartGlobalTableName;

    private final Integer limit;

    private final String regionName;

    private ListGlobalTablesRequest(BuilderImpl builder) {
        super(builder);
        this.exclusiveStartGlobalTableName = builder.exclusiveStartGlobalTableName;
        this.limit = builder.limit;
        this.regionName = builder.regionName;
    }

    /**
     * <p>
     * The first global table name that this operation will evaluate.
     * </p>
     * 
     * @return The first global table name that this operation will evaluate.
     */
    public String exclusiveStartGlobalTableName() {
        return exclusiveStartGlobalTableName;
    }

    /**
     * <p>
     * The maximum number of table names to return.
     * </p>
     * 
     * @return The maximum number of table names to return.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Lists the global tables in a specific region.
     * </p>
     * 
     * @return Lists the global tables in a specific region.
     */
    public String regionName() {
        return regionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartGlobalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGlobalTablesRequest)) {
            return false;
        }
        ListGlobalTablesRequest other = (ListGlobalTablesRequest) obj;
        return Objects.equals(exclusiveStartGlobalTableName(), other.exclusiveStartGlobalTableName())
                && Objects.equals(limit(), other.limit()) && Objects.equals(regionName(), other.regionName());
    }

    @Override
    public String toString() {
        return ToString.builder("ListGlobalTablesRequest").add("ExclusiveStartGlobalTableName", exclusiveStartGlobalTableName())
                .add("Limit", limit()).add("RegionName", regionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExclusiveStartGlobalTableName":
            return Optional.ofNullable(clazz.cast(exclusiveStartGlobalTableName()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDbRequest.Builder, CopyableBuilder<Builder, ListGlobalTablesRequest> {
        /**
         * <p>
         * The first global table name that this operation will evaluate.
         * </p>
         * 
         * @param exclusiveStartGlobalTableName
         *        The first global table name that this operation will evaluate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartGlobalTableName(String exclusiveStartGlobalTableName);

        /**
         * <p>
         * The maximum number of table names to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of table names to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Lists the global tables in a specific region.
         * </p>
         * 
         * @param regionName
         *        Lists the global tables in a specific region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String exclusiveStartGlobalTableName;

        private Integer limit;

        private String regionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGlobalTablesRequest model) {
            super(model);
            exclusiveStartGlobalTableName(model.exclusiveStartGlobalTableName);
            limit(model.limit);
            regionName(model.regionName);
        }

        public final String getExclusiveStartGlobalTableName() {
            return exclusiveStartGlobalTableName;
        }

        @Override
        public final Builder exclusiveStartGlobalTableName(String exclusiveStartGlobalTableName) {
            this.exclusiveStartGlobalTableName = exclusiveStartGlobalTableName;
            return this;
        }

        public final void setExclusiveStartGlobalTableName(String exclusiveStartGlobalTableName) {
            this.exclusiveStartGlobalTableName = exclusiveStartGlobalTableName;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGlobalTablesRequest build() {
            return new ListGlobalTablesRequest(this);
        }
    }
}
