/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContinuousBackupsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<UpdateContinuousBackupsResponse.Builder, UpdateContinuousBackupsResponse> {
    private final ContinuousBackupsDescription continuousBackupsDescription;

    private UpdateContinuousBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.continuousBackupsDescription = builder.continuousBackupsDescription;
    }

    /**
     * <p>
     * Represents the continuous backups and point in time recovery settings on the table.
     * </p>
     * 
     * @return Represents the continuous backups and point in time recovery settings on the table.
     */
    public ContinuousBackupsDescription continuousBackupsDescription() {
        return continuousBackupsDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continuousBackupsDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContinuousBackupsResponse)) {
            return false;
        }
        UpdateContinuousBackupsResponse other = (UpdateContinuousBackupsResponse) obj;
        return Objects.equals(continuousBackupsDescription(), other.continuousBackupsDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateContinuousBackupsResponse")
                .add("ContinuousBackupsDescription", continuousBackupsDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinuousBackupsDescription":
            return Optional.ofNullable(clazz.cast(continuousBackupsDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDbResponse.Builder, CopyableBuilder<Builder, UpdateContinuousBackupsResponse> {
        /**
         * <p>
         * Represents the continuous backups and point in time recovery settings on the table.
         * </p>
         * 
         * @param continuousBackupsDescription
         *        Represents the continuous backups and point in time recovery settings on the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousBackupsDescription(ContinuousBackupsDescription continuousBackupsDescription);

        /**
         * <p>
         * Represents the continuous backups and point in time recovery settings on the table.
         * </p>
         * This is a convenience that creates an instance of the {@link ContinuousBackupsDescription.Builder} avoiding
         * the need to create one manually via {@link ContinuousBackupsDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContinuousBackupsDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #continuousBackupsDescription(ContinuousBackupsDescription)}.
         * 
         * @param continuousBackupsDescription
         *        a consumer that will call methods on {@link ContinuousBackupsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousBackupsDescription(ContinuousBackupsDescription)
         */
        default Builder continuousBackupsDescription(Consumer<ContinuousBackupsDescription.Builder> continuousBackupsDescription) {
            return continuousBackupsDescription(ContinuousBackupsDescription.builder()
                    .applyMutation(continuousBackupsDescription).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private ContinuousBackupsDescription continuousBackupsDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContinuousBackupsResponse model) {
            super(model);
            continuousBackupsDescription(model.continuousBackupsDescription);
        }

        public final ContinuousBackupsDescription.Builder getContinuousBackupsDescription() {
            return continuousBackupsDescription != null ? continuousBackupsDescription.toBuilder() : null;
        }

        @Override
        public final Builder continuousBackupsDescription(ContinuousBackupsDescription continuousBackupsDescription) {
            this.continuousBackupsDescription = continuousBackupsDescription;
            return this;
        }

        public final void setContinuousBackupsDescription(ContinuousBackupsDescription.BuilderImpl continuousBackupsDescription) {
            this.continuousBackupsDescription = continuousBackupsDescription != null ? continuousBackupsDescription.build()
                    : null;
        }

        @Override
        public UpdateContinuousBackupsResponse build() {
            return new UpdateContinuousBackupsResponse(this);
        }
    }
}
