/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.BackupDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of the backup created for the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupDetails implements StructuredPojo, ToCopyableBuilder<BackupDetails.Builder, BackupDetails> {
    private final String backupArn;

    private final String backupName;

    private final Long backupSizeBytes;

    private final String backupStatus;

    private final Instant backupCreationDateTime;

    private BackupDetails(BuilderImpl builder) {
        this.backupArn = builder.backupArn;
        this.backupName = builder.backupName;
        this.backupSizeBytes = builder.backupSizeBytes;
        this.backupStatus = builder.backupStatus;
        this.backupCreationDateTime = builder.backupCreationDateTime;
    }

    /**
     * <p>
     * ARN associated with the backup.
     * </p>
     * 
     * @return ARN associated with the backup.
     */
    public String backupArn() {
        return backupArn;
    }

    /**
     * <p>
     * Name of the requested backup.
     * </p>
     * 
     * @return Name of the requested backup.
     */
    public String backupName() {
        return backupName;
    }

    /**
     * <p>
     * Size of the backup in bytes.
     * </p>
     * 
     * @return Size of the backup in bytes.
     */
    public Long backupSizeBytes() {
        return backupSizeBytes;
    }

    /**
     * <p>
     * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupStatus} will
     * return {@link BackupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupStatusAsString}.
     * </p>
     * 
     * @return Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * @see BackupStatus
     */
    public BackupStatus backupStatus() {
        return BackupStatus.fromValue(backupStatus);
    }

    /**
     * <p>
     * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupStatus} will
     * return {@link BackupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupStatusAsString}.
     * </p>
     * 
     * @return Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * @see BackupStatus
     */
    public String backupStatusAsString() {
        return backupStatus;
    }

    /**
     * <p>
     * Time at which the backup was created. This is the request time of the backup.
     * </p>
     * 
     * @return Time at which the backup was created. This is the request time of the backup.
     */
    public Instant backupCreationDateTime() {
        return backupCreationDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupName());
        hashCode = 31 * hashCode + Objects.hashCode(backupSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(backupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backupCreationDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupDetails)) {
            return false;
        }
        BackupDetails other = (BackupDetails) obj;
        return Objects.equals(backupArn(), other.backupArn()) && Objects.equals(backupName(), other.backupName())
                && Objects.equals(backupSizeBytes(), other.backupSizeBytes())
                && Objects.equals(backupStatusAsString(), other.backupStatusAsString())
                && Objects.equals(backupCreationDateTime(), other.backupCreationDateTime());
    }

    @Override
    public String toString() {
        return ToString.builder("BackupDetails").add("BackupArn", backupArn()).add("BackupName", backupName())
                .add("BackupSizeBytes", backupSizeBytes()).add("BackupStatus", backupStatusAsString())
                .add("BackupCreationDateTime", backupCreationDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupArn":
            return Optional.ofNullable(clazz.cast(backupArn()));
        case "BackupName":
            return Optional.ofNullable(clazz.cast(backupName()));
        case "BackupSizeBytes":
            return Optional.ofNullable(clazz.cast(backupSizeBytes()));
        case "BackupStatus":
            return Optional.ofNullable(clazz.cast(backupStatusAsString()));
        case "BackupCreationDateTime":
            return Optional.ofNullable(clazz.cast(backupCreationDateTime()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BackupDetails> {
        /**
         * <p>
         * ARN associated with the backup.
         * </p>
         * 
         * @param backupArn
         *        ARN associated with the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupArn(String backupArn);

        /**
         * <p>
         * Name of the requested backup.
         * </p>
         * 
         * @param backupName
         *        Name of the requested backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupName(String backupName);

        /**
         * <p>
         * Size of the backup in bytes.
         * </p>
         * 
         * @param backupSizeBytes
         *        Size of the backup in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSizeBytes(Long backupSizeBytes);

        /**
         * <p>
         * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * </p>
         * 
         * @param backupStatus
         *        Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * @see BackupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupStatus
         */
        Builder backupStatus(String backupStatus);

        /**
         * <p>
         * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * </p>
         * 
         * @param backupStatus
         *        Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * @see BackupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupStatus
         */
        Builder backupStatus(BackupStatus backupStatus);

        /**
         * <p>
         * Time at which the backup was created. This is the request time of the backup.
         * </p>
         * 
         * @param backupCreationDateTime
         *        Time at which the backup was created. This is the request time of the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupCreationDateTime(Instant backupCreationDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String backupArn;

        private String backupName;

        private Long backupSizeBytes;

        private String backupStatus;

        private Instant backupCreationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupDetails model) {
            backupArn(model.backupArn);
            backupName(model.backupName);
            backupSizeBytes(model.backupSizeBytes);
            backupStatus(model.backupStatus);
            backupCreationDateTime(model.backupCreationDateTime);
        }

        public final String getBackupArn() {
            return backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        public final String getBackupName() {
            return backupName;
        }

        @Override
        public final Builder backupName(String backupName) {
            this.backupName = backupName;
            return this;
        }

        public final void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        public final Long getBackupSizeBytes() {
            return backupSizeBytes;
        }

        @Override
        public final Builder backupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
            return this;
        }

        public final void setBackupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
        }

        public final String getBackupStatus() {
            return backupStatus;
        }

        @Override
        public final Builder backupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
            return this;
        }

        @Override
        public final Builder backupStatus(BackupStatus backupStatus) {
            this.backupStatus(backupStatus.toString());
            return this;
        }

        public final void setBackupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
        }

        public final Instant getBackupCreationDateTime() {
            return backupCreationDateTime;
        }

        @Override
        public final Builder backupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
            return this;
        }

        public final void setBackupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
        }

        @Override
        public BackupDetails build() {
            return new BackupDetails(this);
        }
    }
}
