/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GlobalTableGlobalSecondaryIndexSettingsUpdate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GlobalTableGlobalSecondaryIndexSettingsUpdateMarshaller {
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").isBinary(false).build();

    private static final MarshallingInfo<Long> PROVISIONEDWRITECAPACITYUNITS_BINDING = MarshallingInfo
            .builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ProvisionedWriteCapacityUnits").isBinary(false).build();

    private static final GlobalTableGlobalSecondaryIndexSettingsUpdateMarshaller INSTANCE = new GlobalTableGlobalSecondaryIndexSettingsUpdateMarshaller();

    private GlobalTableGlobalSecondaryIndexSettingsUpdateMarshaller() {
    }

    public static GlobalTableGlobalSecondaryIndexSettingsUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GlobalTableGlobalSecondaryIndexSettingsUpdate globalTableGlobalSecondaryIndexSettingsUpdate,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(globalTableGlobalSecondaryIndexSettingsUpdate, "globalTableGlobalSecondaryIndexSettingsUpdate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(globalTableGlobalSecondaryIndexSettingsUpdate.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall(globalTableGlobalSecondaryIndexSettingsUpdate.provisionedWriteCapacityUnits(),
                    PROVISIONEDWRITECAPACITYUNITS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
