/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.Capacity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CapacityMarshaller {
    private static final MarshallingInfo<Double> CAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CapacityUnits").isBinary(false).build();
    private static final CapacityMarshaller INSTANCE = new CapacityMarshaller();

    private CapacityMarshaller() {
    }

    public static CapacityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Capacity capacity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)capacity, (String)"capacity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)capacity.capacityUnits(), CAPACITYUNITS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

