/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.CreateReplicaAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateReplicaActionMarshaller {
    private static final MarshallingInfo<String> REGIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegionName").isBinary(false).build();
    private static final CreateReplicaActionMarshaller INSTANCE = new CreateReplicaActionMarshaller();

    private CreateReplicaActionMarshaller() {
    }

    public static CreateReplicaActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateReplicaAction createReplicaAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)createReplicaAction, (String)"createReplicaAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createReplicaAction.regionName(), REGIONNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

