/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutRequestMarshaller {
    private static final MarshallingInfo<Map> ITEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Item").isBinary(false).build();
    private static final PutRequestMarshaller INSTANCE = new PutRequestMarshaller();

    private PutRequestMarshaller() {
    }

    public static PutRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutRequest putRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)putRequest, (String)"putRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(putRequest.item(), ITEM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

