/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.transform.ReplicaSettingsDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of a replica.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaSettingsDescription implements StructuredPojo,
        ToCopyableBuilder<ReplicaSettingsDescription.Builder, ReplicaSettingsDescription> {
    private final String regionName;

    private final String replicaStatus;

    private final Long replicaProvisionedReadCapacityUnits;

    private final Long replicaProvisionedWriteCapacityUnits;

    private final List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings;

    private ReplicaSettingsDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaStatus = builder.replicaStatus;
        this.replicaProvisionedReadCapacityUnits = builder.replicaProvisionedReadCapacityUnits;
        this.replicaProvisionedWriteCapacityUnits = builder.replicaProvisionedWriteCapacityUnits;
        this.replicaGlobalSecondaryIndexSettings = builder.replicaGlobalSecondaryIndexSettings;
    }

    /**
     * <p>
     * The region name of the replica.
     * </p>
     * 
     * @return The region name of the replica.
     */
    public String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The current state of the region:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The region is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The region is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The region is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The region is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaStatus}
     * will return {@link ReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaStatusAsString}.
     * </p>
     * 
     * @return The current state of the region:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The region is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The region is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The region is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The region is ready for use.
     *         </p>
     *         </li>
     * @see ReplicaStatus
     */
    public ReplicaStatus replicaStatus() {
        return ReplicaStatus.fromValue(replicaStatus);
    }

    /**
     * <p>
     * The current state of the region:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The region is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The region is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The region is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The region is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaStatus}
     * will return {@link ReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaStatusAsString}.
     * </p>
     * 
     * @return The current state of the region:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The region is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The region is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The region is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The region is ready for use.
     *         </p>
     *         </li>
     * @see ReplicaStatus
     */
    public String replicaStatusAsString() {
        return replicaStatus;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     *         >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Long replicaProvisionedReadCapacityUnits() {
        return replicaProvisionedReadCapacityUnits;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For
     * more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     *         >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Long replicaProvisionedWriteCapacityUnits() {
        return replicaProvisionedWriteCapacityUnits;
    }

    /**
     * <p>
     * Replica global secondary index settings for the global table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Replica global secondary index settings for the global table.
     */
    public List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings() {
        return replicaGlobalSecondaryIndexSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(replicaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(replicaGlobalSecondaryIndexSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSettingsDescription)) {
            return false;
        }
        ReplicaSettingsDescription other = (ReplicaSettingsDescription) obj;
        return Objects.equals(regionName(), other.regionName())
                && Objects.equals(replicaStatusAsString(), other.replicaStatusAsString())
                && Objects.equals(replicaProvisionedReadCapacityUnits(), other.replicaProvisionedReadCapacityUnits())
                && Objects.equals(replicaProvisionedWriteCapacityUnits(), other.replicaProvisionedWriteCapacityUnits())
                && Objects.equals(replicaGlobalSecondaryIndexSettings(), other.replicaGlobalSecondaryIndexSettings());
    }

    @Override
    public String toString() {
        return ToString.builder("ReplicaSettingsDescription").add("RegionName", regionName())
                .add("ReplicaStatus", replicaStatusAsString())
                .add("ReplicaProvisionedReadCapacityUnits", replicaProvisionedReadCapacityUnits())
                .add("ReplicaProvisionedWriteCapacityUnits", replicaProvisionedWriteCapacityUnits())
                .add("ReplicaGlobalSecondaryIndexSettings", replicaGlobalSecondaryIndexSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "ReplicaStatus":
            return Optional.ofNullable(clazz.cast(replicaStatusAsString()));
        case "ReplicaProvisionedReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(replicaProvisionedReadCapacityUnits()));
        case "ReplicaProvisionedWriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(replicaProvisionedWriteCapacityUnits()));
        case "ReplicaGlobalSecondaryIndexSettings":
            return Optional.ofNullable(clazz.cast(replicaGlobalSecondaryIndexSettings()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicaSettingsDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReplicaSettingsDescription> {
        /**
         * <p>
         * The region name of the replica.
         * </p>
         * 
         * @param regionName
         *        The region name of the replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The current state of the region:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The region is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The region is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The region is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The region is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicaStatus
         *        The current state of the region:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The region is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The region is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The region is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The region is ready for use.
         *        </p>
         *        </li>
         * @see ReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaStatus
         */
        Builder replicaStatus(String replicaStatus);

        /**
         * <p>
         * The current state of the region:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The region is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The region is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The region is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The region is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicaStatus
         *        The current state of the region:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The region is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The region is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The region is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The region is ready for use.
         *        </p>
         *        </li>
         * @see ReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaStatus
         */
        Builder replicaStatus(ReplicaStatus replicaStatus);

        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param replicaProvisionedReadCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         *        >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param replicaProvisionedWriteCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         *        >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedWriteCapacityUnits(Long replicaProvisionedWriteCapacityUnits);

        /**
         * <p>
         * Replica global secondary index settings for the global table.
         * </p>
         * 
         * @param replicaGlobalSecondaryIndexSettings
         *        Replica global secondary index settings for the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaGlobalSecondaryIndexSettings(
                Collection<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings);

        /**
         * <p>
         * Replica global secondary index settings for the global table.
         * </p>
         * 
         * @param replicaGlobalSecondaryIndexSettings
         *        Replica global secondary index settings for the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaGlobalSecondaryIndexSettings(
                ReplicaGlobalSecondaryIndexSettingsDescription... replicaGlobalSecondaryIndexSettings);

        /**
         * <p>
         * Replica global secondary index settings for the global table.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ReplicaGlobalSecondaryIndexSettingsDescription>.Builder} avoiding the need to create one manually via
         * {@link List<ReplicaGlobalSecondaryIndexSettingsDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <ReplicaGlobalSecondaryIndexSettingsDescription>.Builder#build()} is called immediately and its result is
         * passed to {@link #replicaGlobalSecondaryIndexSettings(List<ReplicaGlobalSecondaryIndexSettingsDescription>)}.
         * 
         * @param replicaGlobalSecondaryIndexSettings
         *        a consumer that will call methods on {@link List
         *        <ReplicaGlobalSecondaryIndexSettingsDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaGlobalSecondaryIndexSettings(List<ReplicaGlobalSecondaryIndexSettingsDescription>)
         */
        Builder replicaGlobalSecondaryIndexSettings(
                Consumer<ReplicaGlobalSecondaryIndexSettingsDescription.Builder>... replicaGlobalSecondaryIndexSettings);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private String replicaStatus;

        private Long replicaProvisionedReadCapacityUnits;

        private Long replicaProvisionedWriteCapacityUnits;

        private List<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSettingsDescription model) {
            regionName(model.regionName);
            replicaStatus(model.replicaStatus);
            replicaProvisionedReadCapacityUnits(model.replicaProvisionedReadCapacityUnits);
            replicaProvisionedWriteCapacityUnits(model.replicaProvisionedWriteCapacityUnits);
            replicaGlobalSecondaryIndexSettings(model.replicaGlobalSecondaryIndexSettings);
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getReplicaStatus() {
            return replicaStatus;
        }

        @Override
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        @Override
        public final Builder replicaStatus(ReplicaStatus replicaStatus) {
            this.replicaStatus(replicaStatus.toString());
            return this;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        public final Long getReplicaProvisionedReadCapacityUnits() {
            return replicaProvisionedReadCapacityUnits;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
            return this;
        }

        public final void setReplicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
        }

        public final Long getReplicaProvisionedWriteCapacityUnits() {
            return replicaProvisionedWriteCapacityUnits;
        }

        @Override
        public final Builder replicaProvisionedWriteCapacityUnits(Long replicaProvisionedWriteCapacityUnits) {
            this.replicaProvisionedWriteCapacityUnits = replicaProvisionedWriteCapacityUnits;
            return this;
        }

        public final void setReplicaProvisionedWriteCapacityUnits(Long replicaProvisionedWriteCapacityUnits) {
            this.replicaProvisionedWriteCapacityUnits = replicaProvisionedWriteCapacityUnits;
        }

        public final Collection<ReplicaGlobalSecondaryIndexSettingsDescription.Builder> getReplicaGlobalSecondaryIndexSettings() {
            return replicaGlobalSecondaryIndexSettings != null ? replicaGlobalSecondaryIndexSettings.stream()
                    .map(ReplicaGlobalSecondaryIndexSettingsDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaGlobalSecondaryIndexSettings(
                Collection<ReplicaGlobalSecondaryIndexSettingsDescription> replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings = ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier
                    .copy(replicaGlobalSecondaryIndexSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettings(
                ReplicaGlobalSecondaryIndexSettingsDescription... replicaGlobalSecondaryIndexSettings) {
            replicaGlobalSecondaryIndexSettings(Arrays.asList(replicaGlobalSecondaryIndexSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettings(
                Consumer<ReplicaGlobalSecondaryIndexSettingsDescription.Builder>... replicaGlobalSecondaryIndexSettings) {
            replicaGlobalSecondaryIndexSettings(Stream.of(replicaGlobalSecondaryIndexSettings)
                    .map(c -> ReplicaGlobalSecondaryIndexSettingsDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaGlobalSecondaryIndexSettings(
                Collection<ReplicaGlobalSecondaryIndexSettingsDescription.BuilderImpl> replicaGlobalSecondaryIndexSettings) {
            this.replicaGlobalSecondaryIndexSettings = ReplicaGlobalSecondaryIndexSettingsDescriptionListCopier
                    .copyFromBuilder(replicaGlobalSecondaryIndexSettings);
        }

        @Override
        public ReplicaSettingsDescription build() {
            return new ReplicaSettingsDescription(this);
        }
    }
}
