/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlobalTableResponse extends DynamoDbResponse implements
        ToCopyableBuilder<UpdateGlobalTableResponse.Builder, UpdateGlobalTableResponse> {
    private final GlobalTableDescription globalTableDescription;

    private UpdateGlobalTableResponse(BuilderImpl builder) {
        super(builder);
        this.globalTableDescription = builder.globalTableDescription;
    }

    /**
     * <p>
     * Contains the details of the global table.
     * </p>
     * 
     * @return Contains the details of the global table.
     */
    public GlobalTableDescription globalTableDescription() {
        return globalTableDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalTableDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalTableResponse)) {
            return false;
        }
        UpdateGlobalTableResponse other = (UpdateGlobalTableResponse) obj;
        return Objects.equals(globalTableDescription(), other.globalTableDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateGlobalTableResponse").add("GlobalTableDescription", globalTableDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalTableDescription":
            return Optional.ofNullable(clazz.cast(globalTableDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDbResponse.Builder, CopyableBuilder<Builder, UpdateGlobalTableResponse> {
        /**
         * <p>
         * Contains the details of the global table.
         * </p>
         * 
         * @param globalTableDescription
         *        Contains the details of the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableDescription(GlobalTableDescription globalTableDescription);

        /**
         * <p>
         * Contains the details of the global table.
         * </p>
         * This is a convenience that creates an instance of the {@link GlobalTableDescription.Builder} avoiding the
         * need to create one manually via {@link GlobalTableDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link GlobalTableDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #globalTableDescription(GlobalTableDescription)}.
         * 
         * @param globalTableDescription
         *        a consumer that will call methods on {@link GlobalTableDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalTableDescription(GlobalTableDescription)
         */
        default Builder globalTableDescription(Consumer<GlobalTableDescription.Builder> globalTableDescription) {
            return globalTableDescription(GlobalTableDescription.builder().applyMutation(globalTableDescription).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private GlobalTableDescription globalTableDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalTableResponse model) {
            super(model);
            globalTableDescription(model.globalTableDescription);
        }

        public final GlobalTableDescription.Builder getGlobalTableDescription() {
            return globalTableDescription != null ? globalTableDescription.toBuilder() : null;
        }

        @Override
        public final Builder globalTableDescription(GlobalTableDescription globalTableDescription) {
            this.globalTableDescription = globalTableDescription;
            return this;
        }

        public final void setGlobalTableDescription(GlobalTableDescription.BuilderImpl globalTableDescription) {
            this.globalTableDescription = globalTableDescription != null ? globalTableDescription.build() : null;
        }

        @Override
        public UpdateGlobalTableResponse build() {
            return new UpdateGlobalTableResponse(this);
        }
    }
}
