/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.BackupSummary;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link BackupSummary} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class BackupSummaryMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();

    private static final MarshallingInfo<String> TABLEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableId").isBinary(false).build();

    private static final MarshallingInfo<String> TABLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableArn").isBinary(false).build();

    private static final MarshallingInfo<String> BACKUPARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupArn").isBinary(false).build();

    private static final MarshallingInfo<String> BACKUPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupName").isBinary(false).build();

    private static final MarshallingInfo<Instant> BACKUPCREATIONDATETIME_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("BackupCreationDateTime").isBinary(false).build();

    private static final MarshallingInfo<String> BACKUPSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupStatus").isBinary(false).build();

    private static final MarshallingInfo<Long> BACKUPSIZEBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupSizeBytes").isBinary(false).build();

    private static final BackupSummaryMarshaller INSTANCE = new BackupSummaryMarshaller();

    private BackupSummaryMarshaller() {
    }

    public static BackupSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(BackupSummary backupSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(backupSummary, "backupSummary");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(backupSummary.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(backupSummary.tableId(), TABLEID_BINDING);
            protocolMarshaller.marshall(backupSummary.tableArn(), TABLEARN_BINDING);
            protocolMarshaller.marshall(backupSummary.backupArn(), BACKUPARN_BINDING);
            protocolMarshaller.marshall(backupSummary.backupName(), BACKUPNAME_BINDING);
            protocolMarshaller.marshall(backupSummary.backupCreationDateTime(), BACKUPCREATIONDATETIME_BINDING);
            protocolMarshaller.marshall(backupSummary.backupStatusAsString(), BACKUPSTATUS_BINDING);
            protocolMarshaller.marshall(backupSummary.backupSizeBytes(), BACKUPSIZEBYTES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
