/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GlobalTableDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GlobalTableDescriptionUnmarshaller implements Unmarshaller<GlobalTableDescription, JsonUnmarshallerContext> {

    public GlobalTableDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        GlobalTableDescription.Builder globalTableDescriptionBuilder = GlobalTableDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ReplicationGroup", targetDepth)) {
                    context.nextToken();
                    globalTableDescriptionBuilder.replicationGroup(new ListUnmarshaller<ReplicaDescription>(
                            ReplicaDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("GlobalTableArn", targetDepth)) {
                    context.nextToken();
                    globalTableDescriptionBuilder.globalTableArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationDateTime", targetDepth)) {
                    context.nextToken();
                    globalTableDescriptionBuilder.creationDateTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("GlobalTableStatus", targetDepth)) {
                    context.nextToken();
                    globalTableDescriptionBuilder.globalTableStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("GlobalTableName", targetDepth)) {
                    context.nextToken();
                    globalTableDescriptionBuilder.globalTableName(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return globalTableDescriptionBuilder.build();
    }

    private static final GlobalTableDescriptionUnmarshaller INSTANCE = new GlobalTableDescriptionUnmarshaller();

    public static GlobalTableDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
