/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReplicaUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGlobalTableRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, UpdateGlobalTableRequest> {
    private final String globalTableName;
    private final List<ReplicaUpdate> replicaUpdates;

    private UpdateGlobalTableRequest(BuilderImpl builder) {
        super(builder);
        this.globalTableName = builder.globalTableName;
        this.replicaUpdates = builder.replicaUpdates;
    }

    public String globalTableName() {
        return this.globalTableName;
    }

    public List<ReplicaUpdate> replicaUpdates() {
        return this.replicaUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaUpdates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalTableRequest)) {
            return false;
        }
        UpdateGlobalTableRequest other = (UpdateGlobalTableRequest)((Object)obj);
        return Objects.equals(this.globalTableName(), other.globalTableName()) && Objects.equals(this.replicaUpdates(), other.replicaUpdates());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGlobalTableRequest").add("GlobalTableName", (Object)this.globalTableName()).add("ReplicaUpdates", this.replicaUpdates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.globalTableName()));
            }
            case "ReplicaUpdates": {
                return Optional.ofNullable(clazz.cast(this.replicaUpdates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String globalTableName;
        private List<ReplicaUpdate> replicaUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalTableRequest model) {
            super(model);
            this.globalTableName(model.globalTableName);
            this.replicaUpdates(model.replicaUpdates);
        }

        public final String getGlobalTableName() {
            return this.globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public final Collection<ReplicaUpdate.Builder> getReplicaUpdates() {
            return this.replicaUpdates != null ? (Collection)this.replicaUpdates.stream().map(ReplicaUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaUpdates(Collection<ReplicaUpdate> replicaUpdates) {
            this.replicaUpdates = ReplicaUpdateListCopier.copy(replicaUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(ReplicaUpdate ... replicaUpdates) {
            this.replicaUpdates(Arrays.asList(replicaUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(Consumer<ReplicaUpdate.Builder> ... replicaUpdates) {
            this.replicaUpdates(Stream.of(replicaUpdates).map(c -> (ReplicaUpdate)((ReplicaUpdate.Builder)ReplicaUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaUpdates(Collection<ReplicaUpdate.BuilderImpl> replicaUpdates) {
            this.replicaUpdates = ReplicaUpdateListCopier.copyFromBuilder(replicaUpdates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalTableRequest build() {
            return new UpdateGlobalTableRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    CopyableBuilder<Builder, UpdateGlobalTableRequest> {
        public Builder globalTableName(String var1);

        public Builder replicaUpdates(Collection<ReplicaUpdate> var1);

        public Builder replicaUpdates(ReplicaUpdate ... var1);

        public Builder replicaUpdates(Consumer<ReplicaUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

