/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.PointInTimeRecoverySpecificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings used to enable point in time recovery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PointInTimeRecoverySpecification implements StructuredPojo,
        ToCopyableBuilder<PointInTimeRecoverySpecification.Builder, PointInTimeRecoverySpecification> {
    private final Boolean pointInTimeRecoveryEnabled;

    private PointInTimeRecoverySpecification(BuilderImpl builder) {
        this.pointInTimeRecoveryEnabled = builder.pointInTimeRecoveryEnabled;
    }

    /**
     * <p>
     * Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
     * </p>
     * 
     * @return Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
     */
    public Boolean pointInTimeRecoveryEnabled() {
        return pointInTimeRecoveryEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeRecoveryEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointInTimeRecoverySpecification)) {
            return false;
        }
        PointInTimeRecoverySpecification other = (PointInTimeRecoverySpecification) obj;
        return Objects.equals(pointInTimeRecoveryEnabled(), other.pointInTimeRecoveryEnabled());
    }

    @Override
    public String toString() {
        return ToString.builder("PointInTimeRecoverySpecification")
                .add("PointInTimeRecoveryEnabled", pointInTimeRecoveryEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PointInTimeRecoveryEnabled":
            return Optional.ofNullable(clazz.cast(pointInTimeRecoveryEnabled()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PointInTimeRecoverySpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PointInTimeRecoverySpecification> {
        /**
         * <p>
         * Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
         * </p>
         * 
         * @param pointInTimeRecoveryEnabled
         *        Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointInTimeRecoveryEnabled(Boolean pointInTimeRecoveryEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean pointInTimeRecoveryEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PointInTimeRecoverySpecification model) {
            pointInTimeRecoveryEnabled(model.pointInTimeRecoveryEnabled);
        }

        public final Boolean getPointInTimeRecoveryEnabled() {
            return pointInTimeRecoveryEnabled;
        }

        @Override
        public final Builder pointInTimeRecoveryEnabled(Boolean pointInTimeRecoveryEnabled) {
            this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
            return this;
        }

        public final void setPointInTimeRecoveryEnabled(Boolean pointInTimeRecoveryEnabled) {
            this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
        }

        @Override
        public PointInTimeRecoverySpecification build() {
            return new PointInTimeRecoverySpecification(this);
        }
    }
}
