/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.SSEDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the server-side encryption status on the specified table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SSEDescription implements StructuredPojo, ToCopyableBuilder<SSEDescription.Builder, SSEDescription> {
    private final String status;

    private SSEDescription(BuilderImpl builder) {
        this.status = builder.status;
    }

    /**
     * <p>
     * The current state of server-side encryption:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLING</code> - Server-side encryption is being enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> - Server-side encryption is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLING</code> - Server-side encryption is being disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - Server-side encryption is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SSEStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of server-side encryption:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLING</code> - Server-side encryption is being enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Server-side encryption is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLING</code> - Server-side encryption is being disabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - Server-side encryption is disabled.
     *         </p>
     *         </li>
     * @see SSEStatus
     */
    public SSEStatus status() {
        return SSEStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of server-side encryption:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLING</code> - Server-side encryption is being enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> - Server-side encryption is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLING</code> - Server-side encryption is being disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - Server-side encryption is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SSEStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of server-side encryption:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLING</code> - Server-side encryption is being enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Server-side encryption is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLING</code> - Server-side encryption is being disabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - Server-side encryption is disabled.
     *         </p>
     *         </li>
     * @see SSEStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSEDescription)) {
            return false;
        }
        SSEDescription other = (SSEDescription) obj;
        return Objects.equals(statusAsString(), other.statusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("SSEDescription").add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SSEDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SSEDescription> {
        /**
         * <p>
         * The current state of server-side encryption:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLING</code> - Server-side encryption is being enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> - Server-side encryption is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLING</code> - Server-side encryption is being disabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - Server-side encryption is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current state of server-side encryption:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLING</code> - Server-side encryption is being enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Server-side encryption is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLING</code> - Server-side encryption is being disabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - Server-side encryption is disabled.
         *        </p>
         *        </li>
         * @see SSEStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of server-side encryption:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLING</code> - Server-side encryption is being enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> - Server-side encryption is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLING</code> - Server-side encryption is being disabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - Server-side encryption is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current state of server-side encryption:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLING</code> - Server-side encryption is being enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Server-side encryption is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLING</code> - Server-side encryption is being disabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - Server-side encryption is disabled.
         *        </p>
         *        </li>
         * @see SSEStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEStatus
         */
        Builder status(SSEStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SSEDescription model) {
            status(model.status);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SSEStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public SSEDescription build() {
            return new SSEDescription(this);
        }
    }
}
