/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.StreamMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents all of the data describing a particular stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Stream implements StructuredPojo, ToCopyableBuilder<Stream.Builder, Stream> {
    private final String streamArn;

    private final String tableName;

    private final String streamLabel;

    private Stream(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.tableName = builder.tableName;
        this.streamLabel = builder.streamLabel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the stream.
     */
    public String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The DynamoDB table with which the stream is associated.
     * </p>
     * 
     * @return The DynamoDB table with which the stream is associated.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A timestamp, in ISO 8601 format, for this stream.
     * </p>
     * <p>
     * Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible that a
     * stream from another table might have the same timestamp. However, the combination of the following three elements
     * is guaranteed to be unique:
     * </p>
     * <ul>
     * <li>
     * <p>
     * the AWS customer ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * the table name
     * </p>
     * </li>
     * <li>
     * <p>
     * the <code>StreamLabel</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return A timestamp, in ISO 8601 format, for this stream.</p>
     *         <p>
     *         Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is
     *         possible that a stream from another table might have the same timestamp. However, the combination of the
     *         following three elements is guaranteed to be unique:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         the AWS customer ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         the table name
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         the <code>StreamLabel</code>
     *         </p>
     *         </li>
     */
    public String streamLabel() {
        return streamLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(streamLabel());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stream)) {
            return false;
        }
        Stream other = (Stream) obj;
        return Objects.equals(streamArn(), other.streamArn()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(streamLabel(), other.streamLabel());
    }

    @Override
    public String toString() {
        return ToString.builder("Stream").add("StreamArn", streamArn()).add("TableName", tableName())
                .add("StreamLabel", streamLabel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "StreamLabel":
            return Optional.ofNullable(clazz.cast(streamLabel()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Stream> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the stream.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) for the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The DynamoDB table with which the stream is associated.
         * </p>
         * 
         * @param tableName
         *        The DynamoDB table with which the stream is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A timestamp, in ISO 8601 format, for this stream.
         * </p>
         * <p>
         * Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible
         * that a stream from another table might have the same timestamp. However, the combination of the following
         * three elements is guaranteed to be unique:
         * </p>
         * <ul>
         * <li>
         * <p>
         * the AWS customer ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * the table name
         * </p>
         * </li>
         * <li>
         * <p>
         * the <code>StreamLabel</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamLabel
         *        A timestamp, in ISO 8601 format, for this stream.</p>
         *        <p>
         *        Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is
         *        possible that a stream from another table might have the same timestamp. However, the combination of
         *        the following three elements is guaranteed to be unique:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        the AWS customer ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        the table name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        the <code>StreamLabel</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamLabel(String streamLabel);
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private String tableName;

        private String streamLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(Stream model) {
            streamArn(model.streamArn);
            tableName(model.tableName);
            streamLabel(model.streamLabel);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getStreamLabel() {
            return streamLabel;
        }

        @Override
        public final Builder streamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
            return this;
        }

        public final void setStreamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
        }

        @Override
        public Stream build() {
            return new Stream(this);
        }
    }
}
