/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GlobalSecondaryIndexInfoMarshaller {
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").isBinary(false).build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROJECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Projection").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONEDTHROUGHPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedThroughput").isBinary(false).build();
    private static final GlobalSecondaryIndexInfoMarshaller INSTANCE = new GlobalSecondaryIndexInfoMarshaller();

    private GlobalSecondaryIndexInfoMarshaller() {
    }

    public static GlobalSecondaryIndexInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GlobalSecondaryIndexInfo globalSecondaryIndexInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)globalSecondaryIndexInfo, (String)"globalSecondaryIndexInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)globalSecondaryIndexInfo.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall(globalSecondaryIndexInfo.keySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexInfo.projection(), PROJECTION_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexInfo.provisionedThroughput(), PROVISIONEDTHROUGHPUT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

