/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KeySchemaElementMarshaller {
    private static final MarshallingInfo<String> ATTRIBUTENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeName").isBinary(false).build();
    private static final MarshallingInfo<String> KEYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyType").isBinary(false).build();
    private static final KeySchemaElementMarshaller INSTANCE = new KeySchemaElementMarshaller();

    private KeySchemaElementMarshaller() {
    }

    public static KeySchemaElementMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeySchemaElement keySchemaElement, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)keySchemaElement, (String)"keySchemaElement");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)keySchemaElement.attributeName(), ATTRIBUTENAME_BINDING);
            protocolMarshaller.marshall((Object)keySchemaElement.keyTypeAsString(), KEYTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

