/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.CreateReplicaActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a replica to be added.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicaAction implements StructuredPojo,
        ToCopyableBuilder<CreateReplicaAction.Builder, CreateReplicaAction> {
    private final String regionName;

    private CreateReplicaAction(BuilderImpl builder) {
        this.regionName = builder.regionName;
    }

    /**
     * <p>
     * The region of the replica to be added.
     * </p>
     * 
     * @return The region of the replica to be added.
     */
    public String regionName() {
        return regionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicaAction)) {
            return false;
        }
        CreateReplicaAction other = (CreateReplicaAction) obj;
        return Objects.equals(regionName(), other.regionName());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateReplicaAction").add("RegionName", regionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateReplicaActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CreateReplicaAction> {
        /**
         * <p>
         * The region of the replica to be added.
         * </p>
         * 
         * @param regionName
         *        The region of the replica to be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicaAction model) {
            regionName(model.regionName);
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public CreateReplicaAction build() {
            return new CreateReplicaAction(this);
        }
    }
}
