/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.TimeToLiveSpecificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings used to enable or disable Time to Live for the specified table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeToLiveSpecification implements StructuredPojo,
        ToCopyableBuilder<TimeToLiveSpecification.Builder, TimeToLiveSpecification> {
    private final Boolean enabled;

    private final String attributeName;

    private TimeToLiveSpecification(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.attributeName = builder.attributeName;
    }

    /**
     * <p>
     * Indicates whether Time To Live is to be enabled (true) or disabled (false) on the table.
     * </p>
     * 
     * @return Indicates whether Time To Live is to be enabled (true) or disabled (false) on the table.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The name of the Time to Live attribute used to store the expiration time for items in the table.
     * </p>
     * 
     * @return The name of the Time to Live attribute used to store the expiration time for items in the table.
     */
    public String attributeName() {
        return attributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeToLiveSpecification)) {
            return false;
        }
        TimeToLiveSpecification other = (TimeToLiveSpecification) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(attributeName(), other.attributeName());
    }

    @Override
    public String toString() {
        return ToString.builder("TimeToLiveSpecification").add("Enabled", enabled()).add("AttributeName", attributeName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeToLiveSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TimeToLiveSpecification> {
        /**
         * <p>
         * Indicates whether Time To Live is to be enabled (true) or disabled (false) on the table.
         * </p>
         * 
         * @param enabled
         *        Indicates whether Time To Live is to be enabled (true) or disabled (false) on the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The name of the Time to Live attribute used to store the expiration time for items in the table.
         * </p>
         * 
         * @param attributeName
         *        The name of the Time to Live attribute used to store the expiration time for items in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeToLiveSpecification model) {
            enabled(model.enabled);
            attributeName(model.attributeName);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public TimeToLiveSpecification build() {
            return new TimeToLiveSpecification(this);
        }
    }
}
