/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.SourceTableFeatureDetails;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SourceTableFeatureDetails} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SourceTableFeatureDetailsMarshaller {
    private static final MarshallingInfo<List> LOCALSECONDARYINDEXES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalSecondaryIndexes").isBinary(false).build();

    private static final MarshallingInfo<List> GLOBALSECONDARYINDEXES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalSecondaryIndexes").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> STREAMDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("StreamDescription").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> TIMETOLIVEDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("TimeToLiveDescription").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> SSEDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SSEDescription").isBinary(false).build();

    private static final SourceTableFeatureDetailsMarshaller INSTANCE = new SourceTableFeatureDetailsMarshaller();

    private SourceTableFeatureDetailsMarshaller() {
    }

    public static SourceTableFeatureDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SourceTableFeatureDetails sourceTableFeatureDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(sourceTableFeatureDetails, "sourceTableFeatureDetails");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(sourceTableFeatureDetails.localSecondaryIndexes(), LOCALSECONDARYINDEXES_BINDING);
            protocolMarshaller.marshall(sourceTableFeatureDetails.globalSecondaryIndexes(), GLOBALSECONDARYINDEXES_BINDING);
            protocolMarshaller.marshall(sourceTableFeatureDetails.streamDescription(), STREAMDESCRIPTION_BINDING);
            protocolMarshaller.marshall(sourceTableFeatureDetails.timeToLiveDescription(), TIMETOLIVEDESCRIPTION_BINDING);
            protocolMarshaller.marshall(sourceTableFeatureDetails.sseDescription(), SSEDESCRIPTION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
