/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * StreamDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StreamDescriptionUnmarshaller implements Unmarshaller<StreamDescription, JsonUnmarshallerContext> {

    public StreamDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        StreamDescription.Builder streamDescriptionBuilder = StreamDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("StreamArn", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StreamLabel", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamLabel(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StreamStatus", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StreamViewType", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.streamViewType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationRequestDateTime", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.creationRequestDateTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.tableName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KeySchema", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.keySchema(new ListUnmarshaller<KeySchemaElement>(KeySchemaElementUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("Shards", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.shards(new ListUnmarshaller<Shard>(ShardUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("LastEvaluatedShardId", targetDepth)) {
                    context.nextToken();
                    streamDescriptionBuilder.lastEvaluatedShardId(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return streamDescriptionBuilder.build();
    }

    private static final StreamDescriptionUnmarshaller INSTANCE = new StreamDescriptionUnmarshaller();

    public static StreamDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
