/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus;
import software.amazon.awssdk.services.dynamodb.transform.PointInTimeRecoveryDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PointInTimeRecoveryDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, PointInTimeRecoveryDescription> {
    private final String pointInTimeRecoveryStatus;
    private final Instant earliestRestorableDateTime;
    private final Instant latestRestorableDateTime;

    private PointInTimeRecoveryDescription(BuilderImpl builder) {
        this.pointInTimeRecoveryStatus = builder.pointInTimeRecoveryStatus;
        this.earliestRestorableDateTime = builder.earliestRestorableDateTime;
        this.latestRestorableDateTime = builder.latestRestorableDateTime;
    }

    public PointInTimeRecoveryStatus pointInTimeRecoveryStatus() {
        return PointInTimeRecoveryStatus.fromValue(this.pointInTimeRecoveryStatus);
    }

    public String pointInTimeRecoveryStatusAsString() {
        return this.pointInTimeRecoveryStatus;
    }

    public Instant earliestRestorableDateTime() {
        return this.earliestRestorableDateTime;
    }

    public Instant latestRestorableDateTime() {
        return this.latestRestorableDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pointInTimeRecoveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestRestorableDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestorableDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointInTimeRecoveryDescription)) {
            return false;
        }
        PointInTimeRecoveryDescription other = (PointInTimeRecoveryDescription)obj;
        return Objects.equals(this.pointInTimeRecoveryStatusAsString(), other.pointInTimeRecoveryStatusAsString()) && Objects.equals(this.earliestRestorableDateTime(), other.earliestRestorableDateTime()) && Objects.equals(this.latestRestorableDateTime(), other.latestRestorableDateTime());
    }

    public String toString() {
        return ToString.builder((String)"PointInTimeRecoveryDescription").add("PointInTimeRecoveryStatus", (Object)this.pointInTimeRecoveryStatusAsString()).add("EarliestRestorableDateTime", (Object)this.earliestRestorableDateTime()).add("LatestRestorableDateTime", (Object)this.latestRestorableDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PointInTimeRecoveryStatus": {
                return Optional.ofNullable(clazz.cast(this.pointInTimeRecoveryStatusAsString()));
            }
            case "EarliestRestorableDateTime": {
                return Optional.ofNullable(clazz.cast(this.earliestRestorableDateTime()));
            }
            case "LatestRestorableDateTime": {
                return Optional.ofNullable(clazz.cast(this.latestRestorableDateTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PointInTimeRecoveryDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String pointInTimeRecoveryStatus;
        private Instant earliestRestorableDateTime;
        private Instant latestRestorableDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PointInTimeRecoveryDescription model) {
            this.pointInTimeRecoveryStatus(model.pointInTimeRecoveryStatus);
            this.earliestRestorableDateTime(model.earliestRestorableDateTime);
            this.latestRestorableDateTime(model.latestRestorableDateTime);
        }

        public final String getPointInTimeRecoveryStatus() {
            return this.pointInTimeRecoveryStatus;
        }

        @Override
        public final Builder pointInTimeRecoveryStatus(String pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus = pointInTimeRecoveryStatus;
            return this;
        }

        @Override
        public final Builder pointInTimeRecoveryStatus(PointInTimeRecoveryStatus pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus(pointInTimeRecoveryStatus.toString());
            return this;
        }

        public final void setPointInTimeRecoveryStatus(String pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus = pointInTimeRecoveryStatus;
        }

        public final Instant getEarliestRestorableDateTime() {
            return this.earliestRestorableDateTime;
        }

        @Override
        public final Builder earliestRestorableDateTime(Instant earliestRestorableDateTime) {
            this.earliestRestorableDateTime = earliestRestorableDateTime;
            return this;
        }

        public final void setEarliestRestorableDateTime(Instant earliestRestorableDateTime) {
            this.earliestRestorableDateTime = earliestRestorableDateTime;
        }

        public final Instant getLatestRestorableDateTime() {
            return this.latestRestorableDateTime;
        }

        @Override
        public final Builder latestRestorableDateTime(Instant latestRestorableDateTime) {
            this.latestRestorableDateTime = latestRestorableDateTime;
            return this;
        }

        public final void setLatestRestorableDateTime(Instant latestRestorableDateTime) {
            this.latestRestorableDateTime = latestRestorableDateTime;
        }

        public PointInTimeRecoveryDescription build() {
            return new PointInTimeRecoveryDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PointInTimeRecoveryDescription> {
        public Builder pointInTimeRecoveryStatus(String var1);

        public Builder pointInTimeRecoveryStatus(PointInTimeRecoveryStatus var1);

        public Builder earliestRestorableDateTime(Instant var1);

        public Builder latestRestorableDateTime(Instant var1);
    }
}

