/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateGlobalTableRequestModelMarshaller {
    private static final MarshallingInfo<String> GLOBALTABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalTableName").isBinary(false).build();
    private static final MarshallingInfo<List> REPLICATIONGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationGroup").isBinary(false).build();
    private static final CreateGlobalTableRequestModelMarshaller INSTANCE = new CreateGlobalTableRequestModelMarshaller();

    private CreateGlobalTableRequestModelMarshaller() {
    }

    public static CreateGlobalTableRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateGlobalTableRequest createGlobalTableRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createGlobalTableRequest), (String)"createGlobalTableRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createGlobalTableRequest.globalTableName(), GLOBALTABLENAME_BINDING);
            protocolMarshaller.marshall(createGlobalTableRequest.replicationGroup(), REPLICATIONGROUP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

