/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>Scan</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanRequest extends DynamoDbRequest implements ToCopyableBuilder<ScanRequest.Builder, ScanRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScanRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScanRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ScanRequest::attributesToGet))
            .setter(setter(Builder::attributesToGet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScanRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> SELECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScanRequest::selectAsString)).setter(setter(Builder::select))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Select").build()).build();

    private static final SdkField<Map<String, Condition>> SCAN_FILTER_FIELD = SdkField
            .<Map<String, Condition>> builder(MarshallingType.MAP)
            .getter(getter(ScanRequest::scanFilter))
            .setter(setter(Builder::scanFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanFilter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Condition> builder(MarshallingType.SDK_POJO)
                                            .constructor(Condition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONDITIONAL_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScanRequest::conditionalOperatorAsString)).setter(setter(Builder::conditionalOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalOperator").build())
            .build();

    private static final SdkField<Map<String, AttributeValue>> EXCLUSIVE_START_KEY_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .getter(getter(ScanRequest::exclusiveStartKey))
            .setter(setter(Builder::exclusiveStartKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartKey").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScanRequest::returnConsumedCapacityAsString)).setter(setter(Builder::returnConsumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build())
            .build();

    private static final SdkField<Integer> TOTAL_SEGMENTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScanRequest::totalSegments)).setter(setter(Builder::totalSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSegments").build()).build();

    private static final SdkField<Integer> SEGMENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ScanRequest::segment)).setter(setter(Builder::segment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segment").build()).build();

    private static final SdkField<String> PROJECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScanRequest::projectionExpression)).setter(setter(Builder::projectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionExpression").build())
            .build();

    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScanRequest::filterExpression)).setter(setter(Builder::filterExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()).build();

    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ScanRequest::expressionAttributeNames))
            .setter(setter(Builder::expressionAttributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .getter(getter(ScanRequest::expressionAttributeValues))
            .setter(setter(Builder::expressionAttributeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> CONSISTENT_READ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ScanRequest::consistentRead)).setter(setter(Builder::consistentRead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistentRead").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            INDEX_NAME_FIELD, ATTRIBUTES_TO_GET_FIELD, LIMIT_FIELD, SELECT_FIELD, SCAN_FILTER_FIELD, CONDITIONAL_OPERATOR_FIELD,
            EXCLUSIVE_START_KEY_FIELD, RETURN_CONSUMED_CAPACITY_FIELD, TOTAL_SEGMENTS_FIELD, SEGMENT_FIELD,
            PROJECTION_EXPRESSION_FIELD, FILTER_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD,
            EXPRESSION_ATTRIBUTE_VALUES_FIELD, CONSISTENT_READ_FIELD));

    private final String tableName;

    private final String indexName;

    private final List<String> attributesToGet;

    private final Integer limit;

    private final String select;

    private final Map<String, Condition> scanFilter;

    private final String conditionalOperator;

    private final Map<String, AttributeValue> exclusiveStartKey;

    private final String returnConsumedCapacity;

    private final Integer totalSegments;

    private final Integer segment;

    private final String projectionExpression;

    private final String filterExpression;

    private final Map<String, String> expressionAttributeNames;

    private final Map<String, AttributeValue> expressionAttributeValues;

    private final Boolean consistentRead;

    private ScanRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.select = builder.select;
        this.scanFilter = builder.scanFilter;
        this.conditionalOperator = builder.conditionalOperator;
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.totalSegments = builder.totalSegments;
        this.segment = builder.segment;
        this.projectionExpression = builder.projectionExpression;
        this.filterExpression = builder.filterExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
        this.consistentRead = builder.consistentRead;
    }

    /**
     * <p>
     * The name of the table containing the requested items; or, if you provide <code>IndexName</code>, the name of the
     * table to which that index belongs.
     * </p>
     * 
     * @return The name of the table containing the requested items; or, if you provide <code>IndexName</code>, the name
     *         of the table to which that index belongs.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of a secondary index to scan. This index can be any local secondary index or global secondary index.
     * Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName</code>.
     * </p>
     * 
     * @return The name of a secondary index to scan. This index can be any local secondary index or global secondary
     *         index. Note that if you use the <code>IndexName</code> parameter, you must also provide
     *         <code>TableName</code>.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
     * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
     *         >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public List<String> attributesToGet() {
        return attributesToGet;
    }

    /**
     * <p>
     * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the
     * number of items up to the limit while processing the results, it stops the operation and returns the matching
     * values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that
     * you can pick up where you left off. Also, if the processed data set size exceeds 1 MB before DynamoDB reaches
     * this limit, it stops the operation and returns the matching values up to the limit, and a key in
     * <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information,
     * see <a href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and
     * Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB
     *         processes the number of items up to the limit while processing the results, it stops the operation and
     *         returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a
     *         subsequent operation, so that you can pick up where you left off. Also, if the processed data set size
     *         exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values
     *         up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to
     *         continue the operation. For more information, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and
     *         Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the
     * count of matching items, or in the case of an index, some or all of the attributes projected into the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query
     * a local secondary index, then for each matching item in the index DynamoDB will fetch the entire item from the
     * parent table. If the index is configured to project all item attributes, then all of the data can be obtained
     * from the local secondary index, and no fetching is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have
     * been projected into the index. If the index is configured to project all attributes, this return value is
     * equivalent to specifying <code>ALL_ATTRIBUTES</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
     * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
     * <code>Select</code>.
     * </p>
     * <p>
     * If you query or scan a local secondary index and request only attributes that are projected into that index, the
     * operation will read only the index and not the table. If any of the requested attributes are not projected into
     * the local secondary index, DynamoDB will fetch each of these attributes from the parent table. This extra
     * fetching incurs additional throughput cost and latency.
     * </p>
     * <p>
     * If you query or scan a global secondary index, you can only request attributes that are projected into the index.
     * Global secondary index queries cannot fetch attributes from the parent table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
     * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an
     * index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request,
     * unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to
     * specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
     * </p>
     * <note>
     * <p>
     * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be
     * <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #select} will
     * return {@link Select#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectAsString}.
     * </p>
     * 
     * @return The attributes to be returned in the result. You can retrieve all item attributes, specific item
     *         attributes, the count of matching items, or in the case of an index, some or all of the attributes
     *         projected into the index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
     *         you query a local secondary index, then for each matching item in the index DynamoDB will fetch the
     *         entire item from the parent table. If the index is configured to project all item attributes, then all of
     *         the data can be obtained from the local secondary index, and no fetching is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
     *         that have been projected into the index. If the index is configured to project all attributes, this
     *         return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
     *         This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value
     *         for <code>Select</code>.
     *         </p>
     *         <p>
     *         If you query or scan a local secondary index and request only attributes that are projected into that
     *         index, the operation will read only the index and not the table. If any of the requested attributes are
     *         not projected into the local secondary index, DynamoDB will fetch each of these attributes from the
     *         parent table. This extra fetching incurs additional throughput cost and latency.
     *         </p>
     *         <p>
     *         If you query or scan a global secondary index, you can only request attributes that are projected into
     *         the index. Global secondary index queries cannot fetch attributes from the parent table.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
     *         <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
     *         accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in
     *         a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
     *         usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>
     *         .)
     *         </p>
     *         <note>
     *         <p>
     *         If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
     *         only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
     *         </p>
     * @see Select
     */
    public Select select() {
        return Select.fromValue(select);
    }

    /**
     * <p>
     * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the
     * count of matching items, or in the case of an index, some or all of the attributes projected into the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query
     * a local secondary index, then for each matching item in the index DynamoDB will fetch the entire item from the
     * parent table. If the index is configured to project all item attributes, then all of the data can be obtained
     * from the local secondary index, and no fetching is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have
     * been projected into the index. If the index is configured to project all attributes, this return value is
     * equivalent to specifying <code>ALL_ATTRIBUTES</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
     * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
     * <code>Select</code>.
     * </p>
     * <p>
     * If you query or scan a local secondary index and request only attributes that are projected into that index, the
     * operation will read only the index and not the table. If any of the requested attributes are not projected into
     * the local secondary index, DynamoDB will fetch each of these attributes from the parent table. This extra
     * fetching incurs additional throughput cost and latency.
     * </p>
     * <p>
     * If you query or scan a global secondary index, you can only request attributes that are projected into the index.
     * Global secondary index queries cannot fetch attributes from the parent table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
     * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an
     * index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request,
     * unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to
     * specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
     * </p>
     * <note>
     * <p>
     * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be
     * <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #select} will
     * return {@link Select#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectAsString}.
     * </p>
     * 
     * @return The attributes to be returned in the result. You can retrieve all item attributes, specific item
     *         attributes, the count of matching items, or in the case of an index, some or all of the attributes
     *         projected into the index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
     *         you query a local secondary index, then for each matching item in the index DynamoDB will fetch the
     *         entire item from the parent table. If the index is configured to project all item attributes, then all of
     *         the data can be obtained from the local secondary index, and no fetching is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
     *         that have been projected into the index. If the index is configured to project all attributes, this
     *         return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
     *         This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value
     *         for <code>Select</code>.
     *         </p>
     *         <p>
     *         If you query or scan a local secondary index and request only attributes that are projected into that
     *         index, the operation will read only the index and not the table. If any of the requested attributes are
     *         not projected into the local secondary index, DynamoDB will fetch each of these attributes from the
     *         parent table. This extra fetching incurs additional throughput cost and latency.
     *         </p>
     *         <p>
     *         If you query or scan a global secondary index, you can only request attributes that are projected into
     *         the index. Global secondary index queries cannot fetch attributes from the parent table.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
     *         <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
     *         accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in
     *         a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
     *         usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>
     *         .)
     *         </p>
     *         <note>
     *         <p>
     *         If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
     *         only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
     *         </p>
     * @see Select
     */
    public String selectAsString() {
        return select;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html"
     * >ScanFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html"
     *         >ScanFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, Condition> scanFilter() {
        return scanFilter;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conditionalOperator} will return {@link ConditionalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conditionalOperatorAsString}.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     *         >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @see ConditionalOperator
     */
    public ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(conditionalOperator);
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conditionalOperator} will return {@link ConditionalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conditionalOperatorAsString}.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     *         >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @see ConditionalOperator
     */
    public String conditionalOperatorAsString() {
        return conditionalOperator;
    }

    /**
     * <p>
     * The primary key of the first item that this operation will evaluate. Use the value that was returned for
     * <code>LastEvaluatedKey</code> in the previous operation.
     * </p>
     * <p>
     * The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are allowed.
     * </p>
     * <p>
     * In a parallel scan, a <code>Scan</code> request that includes <code>ExclusiveStartKey</code> must specify the
     * same segment whose previous <code>Scan</code> returned the corresponding value of <code>LastEvaluatedKey</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The primary key of the first item that this operation will evaluate. Use the value that was returned for
     *         <code>LastEvaluatedKey</code> in the previous operation.</p>
     *         <p>
     *         The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are
     *         allowed.
     *         </p>
     *         <p>
     *         In a parallel scan, a <code>Scan</code> request that includes <code>ExclusiveStartKey</code> must specify
     *         the same segment whose previous <code>Scan</code> returned the corresponding value of
     *         <code>LastEvaluatedKey</code>.
     */
    public Map<String, AttributeValue> exclusiveStartKey() {
        return exclusiveStartKey;
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(returnConsumedCapacity);
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public String returnConsumedCapacityAsString() {
        return returnConsumedCapacity;
    }

    /**
     * <p>
     * For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the total number of segments into
     * which the <code>Scan</code> operation will be divided. The value of <code>TotalSegments</code> corresponds to the
     * number of application workers that will perform the parallel scan. For example, if you want to use four
     * application threads to scan a table or an index, specify a <code>TotalSegments</code> value of 4.
     * </p>
     * <p>
     * The value for <code>TotalSegments</code> must be greater than or equal to 1, and less than or equal to 1000000.
     * If you specify a <code>TotalSegments</code> value of 1, the <code>Scan</code> operation will be sequential rather
     * than parallel.
     * </p>
     * <p>
     * If you specify <code>TotalSegments</code>, you must also specify <code>Segment</code>.
     * </p>
     * 
     * @return For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the total number of
     *         segments into which the <code>Scan</code> operation will be divided. The value of
     *         <code>TotalSegments</code> corresponds to the number of application workers that will perform the
     *         parallel scan. For example, if you want to use four application threads to scan a table or an index,
     *         specify a <code>TotalSegments</code> value of 4.</p>
     *         <p>
     *         The value for <code>TotalSegments</code> must be greater than or equal to 1, and less than or equal to
     *         1000000. If you specify a <code>TotalSegments</code> value of 1, the <code>Scan</code> operation will be
     *         sequential rather than parallel.
     *         </p>
     *         <p>
     *         If you specify <code>TotalSegments</code>, you must also specify <code>Segment</code>.
     */
    public Integer totalSegments() {
        return totalSegments;
    }

    /**
     * <p>
     * For a parallel <code>Scan</code> request, <code>Segment</code> identifies an individual segment to be scanned by
     * an application worker.
     * </p>
     * <p>
     * Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four application
     * threads to scan a table or an index, then the first thread specifies a <code>Segment</code> value of 0, the
     * second thread specifies 1, and so on.
     * </p>
     * <p>
     * The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code> request must be used as
     * <code>ExclusiveStartKey</code> with the same segment ID in a subsequent <code>Scan</code> operation.
     * </p>
     * <p>
     * The value for <code>Segment</code> must be greater than or equal to 0, and less than the value provided for
     * <code>TotalSegments</code>.
     * </p>
     * <p>
     * If you provide <code>Segment</code>, you must also provide <code>TotalSegments</code>.
     * </p>
     * 
     * @return For a parallel <code>Scan</code> request, <code>Segment</code> identifies an individual segment to be
     *         scanned by an application worker.</p>
     *         <p>
     *         Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four
     *         application threads to scan a table or an index, then the first thread specifies a <code>Segment</code>
     *         value of 0, the second thread specifies 1, and so on.
     *         </p>
     *         <p>
     *         The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code> request must be
     *         used as <code>ExclusiveStartKey</code> with the same segment ID in a subsequent <code>Scan</code>
     *         operation.
     *         </p>
     *         <p>
     *         The value for <code>Segment</code> must be greater than or equal to 0, and less than the value provided
     *         for <code>TotalSegments</code>.
     *         </p>
     *         <p>
     *         If you provide <code>Segment</code>, you must also provide <code>TotalSegments</code>.
     */
    public Integer segment() {
        return segment;
    }

    /**
     * <p>
     * A string that identifies one or more attributes to retrieve from the specified table or index. These attributes
     * can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by
     * commas.
     * </p>
     * <p>
     * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are
     * not found, they will not appear in the result.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return A string that identifies one or more attributes to retrieve from the specified table or index. These
     *         attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression
     *         must be separated by commas.</p>
     *         <p>
     *         If no attribute names are specified, then all attributes will be returned. If any of the requested
     *         attributes are not found, they will not appear in the result.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String projectionExpression() {
        return projectionExpression;
    }

    /**
     * <p>
     * A string that contains conditions that DynamoDB applies after the <code>Scan</code> operation, but before the
     * data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.
     * </p>
     * <note>
     * <p>
     * A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does
     * not consume any additional read capacity units.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
     * Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return A string that contains conditions that DynamoDB applies after the <code>Scan</code> operation, but before
     *         the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not
     *         returned.</p> <note>
     *         <p>
     *         A <code>FilterExpression</code> is applied after the items have already been read; the process of
     *         filtering does not consume any additional read capacity units.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults"
     *         >Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String filterExpression() {
        return filterExpression;
    }

    /**
     * <p>
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To access an attribute whose name conflicts with a DynamoDB reserved word.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a placeholder for repeating occurrences of an attribute name in an expression.
     * </p>
     * </li>
     * <li>
     * <p>
     * To prevent special characters in an attribute name from being misinterpreted in an expression.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following
     * attribute name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Percentile</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For
     * the complete list of reserved words, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>{"#P":"Percentile"}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You could then use this substitution in an expression, as in this example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#P = :val</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for
     * the actual value at runtime.
     * </p>
     * </note>
     * <p>
     * For more information on expression attribute names, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more substitution tokens for attribute names in an expression. The following are some use cases
     *         for using <code>ExpressionAttributeNames</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To access an attribute whose name conflicts with a DynamoDB reserved word.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a placeholder for repeating occurrences of an attribute name in an expression.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To prevent special characters in an attribute name from being misinterpreted in an expression.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
     *         following attribute name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Percentile</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
     *         expression. (For the complete list of reserved words, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
     *         Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
     *         following for <code>ExpressionAttributeNames</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>{"#P":"Percentile"}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You could then use this substitution in an expression, as in this example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#P = :val</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
     *         placeholders for the actual value at runtime.
     *         </p>
     *         </note>
     *         <p>
     *         For more information on expression attribute names, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, String> expressionAttributeNames() {
        return expressionAttributeNames;
    }

    /**
     * <p>
     * One or more values that can be substituted in an expression.
     * </p>
     * <p>
     * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that
     * you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following:
     * </p>
     * <p>
     * <code>Available | Backordered | Discontinued</code>
     * </p>
     * <p>
     * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     * </p>
     * <p>
     * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     * </p>
     * <p>
     * You could then use these values in an expression, such as this:
     * </p>
     * <p>
     * <code>ProductStatus IN (:avail, :back, :disc)</code>
     * </p>
     * <p>
     * For more information on expression attribute values, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more values that can be substituted in an expression.</p>
     *         <p>
     *         Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
     *         suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the
     *         following:
     *         </p>
     *         <p>
     *         <code>Available | Backordered | Discontinued</code>
     *         </p>
     *         <p>
     *         You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     *         </p>
     *         <p>
     *         <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     *         </p>
     *         <p>
     *         You could then use these values in an expression, such as this:
     *         </p>
     *         <p>
     *         <code>ProductStatus IN (:avail, :back, :disc)</code>
     *         </p>
     *         <p>
     *         For more information on expression attribute values, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     *         >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, AttributeValue> expressionAttributeValues() {
        return expressionAttributeValues;
    }

    /**
     * <p>
     * A Boolean value that determines the read consistency model during the scan:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>ConsistentRead</code> is <code>false</code>, then the data returned from <code>Scan</code> might not
     * contain the results from other recently completed write operations (PutItem, UpdateItem or DeleteItem).
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>ConsistentRead</code> is <code>true</code>, then all of the write operations that completed before the
     * <code>Scan</code> began are guaranteed to be contained in the <code>Scan</code> response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default setting for <code>ConsistentRead</code> is <code>false</code>.
     * </p>
     * <p>
     * The <code>ConsistentRead</code> parameter is not supported on global secondary indexes. If you scan a global
     * secondary index with <code>ConsistentRead</code> set to true, you will receive a <code>ValidationException</code>
     * .
     * </p>
     * 
     * @return A Boolean value that determines the read consistency model during the scan:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>ConsistentRead</code> is <code>false</code>, then the data returned from <code>Scan</code> might
     *         not contain the results from other recently completed write operations (PutItem, UpdateItem or
     *         DeleteItem).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>ConsistentRead</code> is <code>true</code>, then all of the write operations that completed
     *         before the <code>Scan</code> began are guaranteed to be contained in the <code>Scan</code> response.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default setting for <code>ConsistentRead</code> is <code>false</code>.
     *         </p>
     *         <p>
     *         The <code>ConsistentRead</code> parameter is not supported on global secondary indexes. If you scan a
     *         global secondary index with <code>ConsistentRead</code> set to true, you will receive a
     *         <code>ValidationException</code>.
     */
    public Boolean consistentRead() {
        return consistentRead;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(attributesToGet());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(selectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanFilter());
        hashCode = 31 * hashCode + Objects.hashCode(conditionalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartKey());
        hashCode = 31 * hashCode + Objects.hashCode(returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalSegments());
        hashCode = 31 * hashCode + Objects.hashCode(segment());
        hashCode = 31 * hashCode + Objects.hashCode(projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeValues());
        hashCode = 31 * hashCode + Objects.hashCode(consistentRead());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanRequest)) {
            return false;
        }
        ScanRequest other = (ScanRequest) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(attributesToGet(), other.attributesToGet()) && Objects.equals(limit(), other.limit())
                && Objects.equals(selectAsString(), other.selectAsString()) && Objects.equals(scanFilter(), other.scanFilter())
                && Objects.equals(conditionalOperatorAsString(), other.conditionalOperatorAsString())
                && Objects.equals(exclusiveStartKey(), other.exclusiveStartKey())
                && Objects.equals(returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString())
                && Objects.equals(totalSegments(), other.totalSegments()) && Objects.equals(segment(), other.segment())
                && Objects.equals(projectionExpression(), other.projectionExpression())
                && Objects.equals(filterExpression(), other.filterExpression())
                && Objects.equals(expressionAttributeNames(), other.expressionAttributeNames())
                && Objects.equals(expressionAttributeValues(), other.expressionAttributeValues())
                && Objects.equals(consistentRead(), other.consistentRead());
    }

    @Override
    public String toString() {
        return ToString.builder("ScanRequest").add("TableName", tableName()).add("IndexName", indexName())
                .add("AttributesToGet", attributesToGet()).add("Limit", limit()).add("Select", selectAsString())
                .add("ScanFilter", scanFilter()).add("ConditionalOperator", conditionalOperatorAsString())
                .add("ExclusiveStartKey", exclusiveStartKey()).add("ReturnConsumedCapacity", returnConsumedCapacityAsString())
                .add("TotalSegments", totalSegments()).add("Segment", segment())
                .add("ProjectionExpression", projectionExpression()).add("FilterExpression", filterExpression())
                .add("ExpressionAttributeNames", expressionAttributeNames())
                .add("ExpressionAttributeValues", expressionAttributeValues()).add("ConsistentRead", consistentRead()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "AttributesToGet":
            return Optional.ofNullable(clazz.cast(attributesToGet()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "Select":
            return Optional.ofNullable(clazz.cast(selectAsString()));
        case "ScanFilter":
            return Optional.ofNullable(clazz.cast(scanFilter()));
        case "ConditionalOperator":
            return Optional.ofNullable(clazz.cast(conditionalOperatorAsString()));
        case "ExclusiveStartKey":
            return Optional.ofNullable(clazz.cast(exclusiveStartKey()));
        case "ReturnConsumedCapacity":
            return Optional.ofNullable(clazz.cast(returnConsumedCapacityAsString()));
        case "TotalSegments":
            return Optional.ofNullable(clazz.cast(totalSegments()));
        case "Segment":
            return Optional.ofNullable(clazz.cast(segment()));
        case "ProjectionExpression":
            return Optional.ofNullable(clazz.cast(projectionExpression()));
        case "FilterExpression":
            return Optional.ofNullable(clazz.cast(filterExpression()));
        case "ExpressionAttributeNames":
            return Optional.ofNullable(clazz.cast(expressionAttributeNames()));
        case "ExpressionAttributeValues":
            return Optional.ofNullable(clazz.cast(expressionAttributeValues()));
        case "ConsistentRead":
            return Optional.ofNullable(clazz.cast(consistentRead()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScanRequest, T> g) {
        return obj -> g.apply((ScanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ScanRequest> {
        /**
         * <p>
         * The name of the table containing the requested items; or, if you provide <code>IndexName</code>, the name of
         * the table to which that index belongs.
         * </p>
         * 
         * @param tableName
         *        The name of the table containing the requested items; or, if you provide <code>IndexName</code>, the
         *        name of the table to which that index belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of a secondary index to scan. This index can be any local secondary index or global secondary index.
         * Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName</code>.
         * </p>
         * 
         * @param indexName
         *        The name of a secondary index to scan. This index can be any local secondary index or global secondary
         *        index. Note that if you use the <code>IndexName</code> parameter, you must also provide
         *        <code>TableName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param attributesToGet
         *        This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see
         *        <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         *        >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(Collection<String> attributesToGet);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param attributesToGet
         *        This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see
         *        <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         *        >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(String... attributesToGet);

        /**
         * <p>
         * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes
         * the number of items up to the limit while processing the results, it stops the operation and returns the
         * matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
         * operation, so that you can pick up where you left off. Also, if the processed data set size exceeds 1 MB
         * before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit,
         * and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For
         * more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB
         *        processes the number of items up to the limit while processing the results, it stops the operation and
         *        returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a
         *        subsequent operation, so that you can pick up where you left off. Also, if the processed data set size
         *        exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching
         *        values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation
         *        to continue the operation. For more information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and
         *        Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes,
         * the count of matching items, or in the case of an index, some or all of the attributes projected into the
         * index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you
         * query a local secondary index, then for each matching item in the index DynamoDB will fetch the entire item
         * from the parent table. If the index is configured to project all item attributes, then all of the data can be
         * obtained from the local secondary index, and no fetching is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that
         * have been projected into the index. If the index is configured to project all attributes, this return value
         * is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
         * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
         * <code>Select</code>.
         * </p>
         * <p>
         * If you query or scan a local secondary index and request only attributes that are projected into that index,
         * the operation will read only the index and not the table. If any of the requested attributes are not
         * projected into the local secondary index, DynamoDB will fetch each of these attributes from the parent table.
         * This extra fetching incurs additional throughput cost and latency.
         * </p>
         * <p>
         * If you query or scan a global secondary index, you can only request attributes that are projected into the
         * index. Global secondary index queries cannot fetch attributes from the parent table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing
         * an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single
         * request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is
         * equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
         * </p>
         * <note>
         * <p>
         * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only
         * be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
         * </p>
         * </note>
         * 
         * @param select
         *        The attributes to be returned in the result. You can retrieve all item attributes, specific item
         *        attributes, the count of matching items, or in the case of an index, some or all of the attributes
         *        projected into the index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
         *        you query a local secondary index, then for each matching item in the index DynamoDB will fetch the
         *        entire item from the parent table. If the index is configured to project all item attributes, then all
         *        of the data can be obtained from the local secondary index, and no fetching is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
         *        that have been projected into the index. If the index is configured to project all attributes, this
         *        return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
         *        This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any
         *        value for <code>Select</code>.
         *        </p>
         *        <p>
         *        If you query or scan a local secondary index and request only attributes that are projected into that
         *        index, the operation will read only the index and not the table. If any of the requested attributes
         *        are not projected into the local secondary index, DynamoDB will fetch each of these attributes from
         *        the parent table. This extra fetching incurs additional throughput cost and latency.
         *        </p>
         *        <p>
         *        If you query or scan a global secondary index, you can only request attributes that are projected into
         *        the index. Global secondary index queries cannot fetch attributes from the parent table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         *        <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
         *        accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together
         *        in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>.
         *        (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for
         *        <code>Select</code>.)
         *        </p>
         *        <note>
         *        <p>
         *        If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
         *        only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an
         *        error.
         *        </p>
         * @see Select
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Select
         */
        Builder select(String select);

        /**
         * <p>
         * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes,
         * the count of matching items, or in the case of an index, some or all of the attributes projected into the
         * index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you
         * query a local secondary index, then for each matching item in the index DynamoDB will fetch the entire item
         * from the parent table. If the index is configured to project all item attributes, then all of the data can be
         * obtained from the local secondary index, and no fetching is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that
         * have been projected into the index. If the index is configured to project all attributes, this return value
         * is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
         * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
         * <code>Select</code>.
         * </p>
         * <p>
         * If you query or scan a local secondary index and request only attributes that are projected into that index,
         * the operation will read only the index and not the table. If any of the requested attributes are not
         * projected into the local secondary index, DynamoDB will fetch each of these attributes from the parent table.
         * This extra fetching incurs additional throughput cost and latency.
         * </p>
         * <p>
         * If you query or scan a global secondary index, you can only request attributes that are projected into the
         * index. Global secondary index queries cannot fetch attributes from the parent table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing
         * an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single
         * request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is
         * equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
         * </p>
         * <note>
         * <p>
         * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only
         * be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
         * </p>
         * </note>
         * 
         * @param select
         *        The attributes to be returned in the result. You can retrieve all item attributes, specific item
         *        attributes, the count of matching items, or in the case of an index, some or all of the attributes
         *        projected into the index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
         *        you query a local secondary index, then for each matching item in the index DynamoDB will fetch the
         *        entire item from the parent table. If the index is configured to project all item attributes, then all
         *        of the data can be obtained from the local secondary index, and no fetching is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
         *        that have been projected into the index. If the index is configured to project all attributes, this
         *        return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
         *        This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any
         *        value for <code>Select</code>.
         *        </p>
         *        <p>
         *        If you query or scan a local secondary index and request only attributes that are projected into that
         *        index, the operation will read only the index and not the table. If any of the requested attributes
         *        are not projected into the local secondary index, DynamoDB will fetch each of these attributes from
         *        the parent table. This extra fetching incurs additional throughput cost and latency.
         *        </p>
         *        <p>
         *        If you query or scan a global secondary index, you can only request attributes that are projected into
         *        the index. Global secondary index queries cannot fetch attributes from the parent table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         *        <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
         *        accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together
         *        in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>.
         *        (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for
         *        <code>Select</code>.)
         *        </p>
         *        <note>
         *        <p>
         *        If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
         *        only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an
         *        error.
         *        </p>
         * @see Select
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Select
         */
        Builder select(Select select);

        /**
         * <p>
         * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html"
         * >ScanFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param scanFilter
         *        This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html"
         *        >ScanFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanFilter(Map<String, Condition> scanFilter);

        /**
         * <p>
         * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @see ConditionalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(String conditionalOperator);

        /**
         * <p>
         * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @see ConditionalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(ConditionalOperator conditionalOperator);

        /**
         * <p>
         * The primary key of the first item that this operation will evaluate. Use the value that was returned for
         * <code>LastEvaluatedKey</code> in the previous operation.
         * </p>
         * <p>
         * The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are
         * allowed.
         * </p>
         * <p>
         * In a parallel scan, a <code>Scan</code> request that includes <code>ExclusiveStartKey</code> must specify the
         * same segment whose previous <code>Scan</code> returned the corresponding value of
         * <code>LastEvaluatedKey</code>.
         * </p>
         * 
         * @param exclusiveStartKey
         *        The primary key of the first item that this operation will evaluate. Use the value that was returned
         *        for <code>LastEvaluatedKey</code> in the previous operation.</p>
         *        <p>
         *        The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types
         *        are allowed.
         *        </p>
         *        <p>
         *        In a parallel scan, a <code>Scan</code> request that includes <code>ExclusiveStartKey</code> must
         *        specify the same segment whose previous <code>Scan</code> returned the corresponding value of
         *        <code>LastEvaluatedKey</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        /**
         * <p>
         * For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the total number of segments
         * into which the <code>Scan</code> operation will be divided. The value of <code>TotalSegments</code>
         * corresponds to the number of application workers that will perform the parallel scan. For example, if you
         * want to use four application threads to scan a table or an index, specify a <code>TotalSegments</code> value
         * of 4.
         * </p>
         * <p>
         * The value for <code>TotalSegments</code> must be greater than or equal to 1, and less than or equal to
         * 1000000. If you specify a <code>TotalSegments</code> value of 1, the <code>Scan</code> operation will be
         * sequential rather than parallel.
         * </p>
         * <p>
         * If you specify <code>TotalSegments</code>, you must also specify <code>Segment</code>.
         * </p>
         * 
         * @param totalSegments
         *        For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the total number of
         *        segments into which the <code>Scan</code> operation will be divided. The value of
         *        <code>TotalSegments</code> corresponds to the number of application workers that will perform the
         *        parallel scan. For example, if you want to use four application threads to scan a table or an index,
         *        specify a <code>TotalSegments</code> value of 4.</p>
         *        <p>
         *        The value for <code>TotalSegments</code> must be greater than or equal to 1, and less than or equal to
         *        1000000. If you specify a <code>TotalSegments</code> value of 1, the <code>Scan</code> operation will
         *        be sequential rather than parallel.
         *        </p>
         *        <p>
         *        If you specify <code>TotalSegments</code>, you must also specify <code>Segment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSegments(Integer totalSegments);

        /**
         * <p>
         * For a parallel <code>Scan</code> request, <code>Segment</code> identifies an individual segment to be scanned
         * by an application worker.
         * </p>
         * <p>
         * Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four
         * application threads to scan a table or an index, then the first thread specifies a <code>Segment</code> value
         * of 0, the second thread specifies 1, and so on.
         * </p>
         * <p>
         * The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code> request must be used as
         * <code>ExclusiveStartKey</code> with the same segment ID in a subsequent <code>Scan</code> operation.
         * </p>
         * <p>
         * The value for <code>Segment</code> must be greater than or equal to 0, and less than the value provided for
         * <code>TotalSegments</code>.
         * </p>
         * <p>
         * If you provide <code>Segment</code>, you must also provide <code>TotalSegments</code>.
         * </p>
         * 
         * @param segment
         *        For a parallel <code>Scan</code> request, <code>Segment</code> identifies an individual segment to be
         *        scanned by an application worker.</p>
         *        <p>
         *        Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four
         *        application threads to scan a table or an index, then the first thread specifies a
         *        <code>Segment</code> value of 0, the second thread specifies 1, and so on.
         *        </p>
         *        <p>
         *        The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code> request must be
         *        used as <code>ExclusiveStartKey</code> with the same segment ID in a subsequent <code>Scan</code>
         *        operation.
         *        </p>
         *        <p>
         *        The value for <code>Segment</code> must be greater than or equal to 0, and less than the value
         *        provided for <code>TotalSegments</code>.
         *        </p>
         *        <p>
         *        If you provide <code>Segment</code>, you must also provide <code>TotalSegments</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segment(Integer segment);

        /**
         * <p>
         * A string that identifies one or more attributes to retrieve from the specified table or index. These
         * attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must
         * be separated by commas.
         * </p>
         * <p>
         * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes
         * are not found, they will not appear in the result.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param projectionExpression
         *        A string that identifies one or more attributes to retrieve from the specified table or index. These
         *        attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression
         *        must be separated by commas.</p>
         *        <p>
         *        If no attribute names are specified, then all attributes will be returned. If any of the requested
         *        attributes are not found, they will not appear in the result.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectionExpression(String projectionExpression);

        /**
         * <p>
         * A string that contains conditions that DynamoDB applies after the <code>Scan</code> operation, but before the
         * data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not
         * returned.
         * </p>
         * <note>
         * <p>
         * A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering
         * does not consume any additional read capacity units.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults"
         * >Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param filterExpression
         *        A string that contains conditions that DynamoDB applies after the <code>Scan</code> operation, but
         *        before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code>
         *        criteria are not returned.</p> <note>
         *        <p>
         *        A <code>FilterExpression</code> is applied after the items have already been read; the process of
         *        filtering does not consume any additional read capacity units.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults"
         *        >Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);

        /**
         * <p>
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for
         * using <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To access an attribute whose name conflicts with a DynamoDB reserved word.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a placeholder for repeating occurrences of an attribute name in an expression.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent special characters in an attribute name from being misinterpreted in an expression.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
         * following attribute name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Percentile</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression.
         * (For the complete list of reserved words, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
         * <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>{"#P":"Percentile"}</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You could then use this substitution in an expression, as in this example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#P = :val</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders
         * for the actual value at runtime.
         * </p>
         * </note>
         * <p>
         * For more information on expression attribute names, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeNames
         *        One or more substitution tokens for attribute names in an expression. The following are some use cases
         *        for using <code>ExpressionAttributeNames</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To access an attribute whose name conflicts with a DynamoDB reserved word.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a placeholder for repeating occurrences of an attribute name in an expression.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To prevent special characters in an attribute name from being misinterpreted in an expression.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider
         *        the following attribute name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Percentile</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
         *        expression. (For the complete list of reserved words, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
         *        Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
         *        following for <code>ExpressionAttributeNames</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>{"#P":"Percentile"}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You could then use this substitution in an expression, as in this example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#P = :val</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
         *        placeholders for the actual value at runtime.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on expression attribute names, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeNames(Map<String, String> expressionAttributeNames);

        /**
         * <p>
         * One or more values that can be substituted in an expression.
         * </p>
         * <p>
         * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose
         * that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following:
         * </p>
         * <p>
         * <code>Available | Backordered | Discontinued</code>
         * </p>
         * <p>
         * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         * </p>
         * <p>
         * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         * </p>
         * <p>
         * You could then use these values in an expression, such as this:
         * </p>
         * <p>
         * <code>ProductStatus IN (:avail, :back, :disc)</code>
         * </p>
         * <p>
         * For more information on expression attribute values, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeValues
         *        One or more values that can be substituted in an expression.</p>
         *        <p>
         *        Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
         *        suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of
         *        the following:
         *        </p>
         *        <p>
         *        <code>Available | Backordered | Discontinued</code>
         *        </p>
         *        <p>
         *        You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         *        </p>
         *        <p>
         *        <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         *        </p>
         *        <p>
         *        You could then use these values in an expression, such as this:
         *        </p>
         *        <p>
         *        <code>ProductStatus IN (:avail, :back, :disc)</code>
         *        </p>
         *        <p>
         *        For more information on expression attribute values, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         *        >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues);

        /**
         * <p>
         * A Boolean value that determines the read consistency model during the scan:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If <code>ConsistentRead</code> is <code>false</code>, then the data returned from <code>Scan</code> might not
         * contain the results from other recently completed write operations (PutItem, UpdateItem or DeleteItem).
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>ConsistentRead</code> is <code>true</code>, then all of the write operations that completed before
         * the <code>Scan</code> began are guaranteed to be contained in the <code>Scan</code> response.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default setting for <code>ConsistentRead</code> is <code>false</code>.
         * </p>
         * <p>
         * The <code>ConsistentRead</code> parameter is not supported on global secondary indexes. If you scan a global
         * secondary index with <code>ConsistentRead</code> set to true, you will receive a
         * <code>ValidationException</code>.
         * </p>
         * 
         * @param consistentRead
         *        A Boolean value that determines the read consistency model during the scan:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If <code>ConsistentRead</code> is <code>false</code>, then the data returned from <code>Scan</code>
         *        might not contain the results from other recently completed write operations (PutItem, UpdateItem or
         *        DeleteItem).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>ConsistentRead</code> is <code>true</code>, then all of the write operations that completed
         *        before the <code>Scan</code> began are guaranteed to be contained in the <code>Scan</code> response.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default setting for <code>ConsistentRead</code> is <code>false</code>.
         *        </p>
         *        <p>
         *        The <code>ConsistentRead</code> parameter is not supported on global secondary indexes. If you scan a
         *        global secondary index with <code>ConsistentRead</code> set to true, you will receive a
         *        <code>ValidationException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consistentRead(Boolean consistentRead);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableName;

        private String indexName;

        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String select;

        private Map<String, Condition> scanFilter = DefaultSdkAutoConstructMap.getInstance();

        private String conditionalOperator;

        private Map<String, AttributeValue> exclusiveStartKey = DefaultSdkAutoConstructMap.getInstance();

        private String returnConsumedCapacity;

        private Integer totalSegments;

        private Integer segment;

        private String projectionExpression;

        private String filterExpression;

        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();

        private Boolean consistentRead;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanRequest model) {
            super(model);
            tableName(model.tableName);
            indexName(model.indexName);
            attributesToGet(model.attributesToGet);
            limit(model.limit);
            select(model.select);
            scanFilter(model.scanFilter);
            conditionalOperator(model.conditionalOperator);
            exclusiveStartKey(model.exclusiveStartKey);
            returnConsumedCapacity(model.returnConsumedCapacity);
            totalSegments(model.totalSegments);
            segment(model.segment);
            projectionExpression(model.projectionExpression);
            filterExpression(model.filterExpression);
            expressionAttributeNames(model.expressionAttributeNames);
            expressionAttributeValues(model.expressionAttributeValues);
            consistentRead(model.consistentRead);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<String> getAttributesToGet() {
            return attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String... attributesToGet) {
            attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getSelect() {
            return select;
        }

        @Override
        public final Builder select(String select) {
            this.select = select;
            return this;
        }

        @Override
        public final Builder select(Select select) {
            this.select(select.toString());
            return this;
        }

        public final void setSelect(String select) {
            this.select = select;
        }

        public final Map<String, Condition.Builder> getScanFilter() {
            return scanFilter != null ? CollectionUtils.mapValues(scanFilter, Condition::toBuilder) : null;
        }

        @Override
        public final Builder scanFilter(Map<String, Condition> scanFilter) {
            this.scanFilter = FilterConditionMapCopier.copy(scanFilter);
            return this;
        }

        public final void setScanFilter(Map<String, Condition.BuilderImpl> scanFilter) {
            this.scanFilter = FilterConditionMapCopier.copyFromBuilder(scanFilter);
        }

        public final String getConditionalOperator() {
            return conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final Map<String, AttributeValue.Builder> getExclusiveStartKey() {
            return exclusiveStartKey != null ? CollectionUtils.mapValues(exclusiveStartKey, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copy(exclusiveStartKey);
            return this;
        }

        public final void setExclusiveStartKey(Map<String, AttributeValue.BuilderImpl> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copyFromBuilder(exclusiveStartKey);
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final Integer getTotalSegments() {
            return totalSegments;
        }

        @Override
        public final Builder totalSegments(Integer totalSegments) {
            this.totalSegments = totalSegments;
            return this;
        }

        public final void setTotalSegments(Integer totalSegments) {
            this.totalSegments = totalSegments;
        }

        public final Integer getSegment() {
            return segment;
        }

        @Override
        public final Builder segment(Integer segment) {
            this.segment = segment;
            return this;
        }

        public final void setSegment(Integer segment) {
            this.segment = segment;
        }

        public final String getProjectionExpression() {
            return projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return expressionAttributeValues != null ? CollectionUtils.mapValues(expressionAttributeValues,
                    AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        public final Boolean getConsistentRead() {
            return consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ScanRequest build() {
            return new ScanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
