/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The beginning and ending sequence numbers for the stream records contained within a shard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SequenceNumberRange implements SdkPojo, Serializable,
        ToCopyableBuilder<SequenceNumberRange.Builder, SequenceNumberRange> {
    private static final SdkField<String> STARTING_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SequenceNumberRange::startingSequenceNumber)).setter(setter(Builder::startingSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingSequenceNumber").build())
            .build();

    private static final SdkField<String> ENDING_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SequenceNumberRange::endingSequenceNumber)).setter(setter(Builder::endingSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndingSequenceNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STARTING_SEQUENCE_NUMBER_FIELD, ENDING_SEQUENCE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startingSequenceNumber;

    private final String endingSequenceNumber;

    private SequenceNumberRange(BuilderImpl builder) {
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.endingSequenceNumber = builder.endingSequenceNumber;
    }

    /**
     * <p>
     * The first sequence number.
     * </p>
     * 
     * @return The first sequence number.
     */
    public String startingSequenceNumber() {
        return startingSequenceNumber;
    }

    /**
     * <p>
     * The last sequence number.
     * </p>
     * 
     * @return The last sequence number.
     */
    public String endingSequenceNumber() {
        return endingSequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startingSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(endingSequenceNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceNumberRange)) {
            return false;
        }
        SequenceNumberRange other = (SequenceNumberRange) obj;
        return Objects.equals(startingSequenceNumber(), other.startingSequenceNumber())
                && Objects.equals(endingSequenceNumber(), other.endingSequenceNumber());
    }

    @Override
    public String toString() {
        return ToString.builder("SequenceNumberRange").add("StartingSequenceNumber", startingSequenceNumber())
                .add("EndingSequenceNumber", endingSequenceNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartingSequenceNumber":
            return Optional.ofNullable(clazz.cast(startingSequenceNumber()));
        case "EndingSequenceNumber":
            return Optional.ofNullable(clazz.cast(endingSequenceNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SequenceNumberRange, T> g) {
        return obj -> g.apply((SequenceNumberRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SequenceNumberRange> {
        /**
         * <p>
         * The first sequence number.
         * </p>
         * 
         * @param startingSequenceNumber
         *        The first sequence number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingSequenceNumber(String startingSequenceNumber);

        /**
         * <p>
         * The last sequence number.
         * </p>
         * 
         * @param endingSequenceNumber
         *        The last sequence number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endingSequenceNumber(String endingSequenceNumber);
    }

    static final class BuilderImpl implements Builder {
        private String startingSequenceNumber;

        private String endingSequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceNumberRange model) {
            startingSequenceNumber(model.startingSequenceNumber);
            endingSequenceNumber(model.endingSequenceNumber);
        }

        public final String getStartingSequenceNumber() {
            return startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        public final String getEndingSequenceNumber() {
            return endingSequenceNumber;
        }

        @Override
        public final Builder endingSequenceNumber(String endingSequenceNumber) {
            this.endingSequenceNumber = endingSequenceNumber;
            return this;
        }

        public final void setEndingSequenceNumber(String endingSequenceNumber) {
            this.endingSequenceNumber = endingSequenceNumber;
        }

        @Override
        public SequenceNumberRange build() {
            return new SequenceNumberRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
