/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The entire transaction request was rejected.
 * </p>
 * <p>
 * DynamoDB will reject the entire <code>TransactWriteItems</code> request if any of the following is true:
 * </p>
 * <ul>
 * <li>
 * <p>
 * A table in the <code>TransactWriteItems</code> request does not exist.
 * </p>
 * </li>
 * <li>
 * <p>
 * A table in the <code>TransactWriteItems</code> request is on a different account or region.
 * </p>
 * </li>
 * <li>
 * <p>
 * Operations contain item schema violations.
 * </p>
 * </li>
 * <li>
 * <p>
 * More than one write operation (<code>UpdateItem</code>, <code>PutItem</code>, <code>DeleteItem</code>) operates on
 * the same item.
 * </p>
 * </li>
 * <li>
 * <p>
 * More than one check operation operates on the same item.
 * </p>
 * </li>
 * <li>
 * <p>
 * The number of operations sent in the <code>TransactWriteItems</code> request is 0 or greater than 10.
 * </p>
 * </li>
 * <li>
 * <p>
 * A <code>TransactWriteItems</code> request exceeds the maximum 4 MB request size.
 * </p>
 * </li>
 * <li>
 * <p>
 * Any operation in the <code>TransactWriteItems</code> request would cause an item to become larger than 400KB.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactionCanceledException extends DynamoDbException implements
        ToCopyableBuilder<TransactionCanceledException.Builder, TransactionCanceledException> {
    private static final SdkField<List<CancellationReason>> CANCELLATION_REASONS_FIELD = SdkField
            .<List<CancellationReason>> builder(MarshallingType.LIST)
            .getter(getter(TransactionCanceledException::cancellationReasons))
            .setter(setter(Builder::cancellationReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancellationReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CancellationReason> builder(MarshallingType.SDK_POJO)
                                            .constructor(CancellationReason::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCELLATION_REASONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CancellationReason> cancellationReasons;

    private TransactionCanceledException(BuilderImpl builder) {
        super(builder);
        this.cancellationReasons = builder.cancellationReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * A list of cancellation reasons.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of cancellation reasons.
     */
    public List<CancellationReason> cancellationReasons() {
        return cancellationReasons;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactionCanceledException, T> g) {
        return obj -> g.apply((TransactionCanceledException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransactionCanceledException>, DynamoDbException.Builder {
        /**
         * <p>
         * A list of cancellation reasons.
         * </p>
         * 
         * @param cancellationReasons
         *        A list of cancellation reasons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancellationReasons(Collection<CancellationReason> cancellationReasons);

        /**
         * <p>
         * A list of cancellation reasons.
         * </p>
         * 
         * @param cancellationReasons
         *        A list of cancellation reasons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancellationReasons(CancellationReason... cancellationReasons);

        /**
         * <p>
         * A list of cancellation reasons.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CancellationReason>.Builder} avoiding the
         * need to create one manually via {@link List<CancellationReason>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CancellationReason>.Builder#build()} is called immediately
         * and its result is passed to {@link #cancellationReasons(List<CancellationReason>)}.
         * 
         * @param cancellationReasons
         *        a consumer that will call methods on {@link List<CancellationReason>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cancellationReasons(List<CancellationReason>)
         */
        Builder cancellationReasons(Consumer<CancellationReason.Builder>... cancellationReasons);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends DynamoDbException.BuilderImpl implements Builder {
        private List<CancellationReason> cancellationReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransactionCanceledException model) {
            super(model);
            cancellationReasons(model.cancellationReasons);
        }

        public final Collection<CancellationReason.Builder> getCancellationReasons() {
            return cancellationReasons != null ? cancellationReasons.stream().map(CancellationReason::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cancellationReasons(Collection<CancellationReason> cancellationReasons) {
            this.cancellationReasons = CancellationReasonListCopier.copy(cancellationReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancellationReasons(CancellationReason... cancellationReasons) {
            cancellationReasons(Arrays.asList(cancellationReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancellationReasons(Consumer<CancellationReason.Builder>... cancellationReasons) {
            cancellationReasons(Stream.of(cancellationReasons).map(c -> CancellationReason.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCancellationReasons(Collection<CancellationReason.BuilderImpl> cancellationReasons) {
            this.cancellationReasons = CancellationReasonListCopier.copyFromBuilder(cancellationReasons);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public TransactionCanceledException build() {
            return new TransactionCanceledException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
