/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the type of identity that made the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Identity implements SdkPojo, Serializable, ToCopyableBuilder<Identity.Builder, Identity> {
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Identity::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Identity::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRINCIPAL_ID_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String principalId;

    private final String type;

    private Identity(BuilderImpl builder) {
        this.principalId = builder.principalId;
        this.type = builder.type;
    }

    /**
     * <p>
     * A unique identifier for the entity that made the call. For Time To Live, the principalId is
     * "dynamodb.amazonaws.com".
     * </p>
     * 
     * @return A unique identifier for the entity that made the call. For Time To Live, the principalId is
     *         "dynamodb.amazonaws.com".
     */
    public String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The type of the identity. For Time To Live, the type is "Service".
     * </p>
     * 
     * @return The type of the identity. For Time To Live, the type is "Service".
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity) obj;
        return Objects.equals(principalId(), other.principalId()) && Objects.equals(type(), other.type());
    }

    @Override
    public String toString() {
        return ToString.builder("Identity").add("PrincipalId", principalId()).add("Type", type()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Identity, T> g) {
        return obj -> g.apply((Identity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Identity> {
        /**
         * <p>
         * A unique identifier for the entity that made the call. For Time To Live, the principalId is
         * "dynamodb.amazonaws.com".
         * </p>
         * 
         * @param principalId
         *        A unique identifier for the entity that made the call. For Time To Live, the principalId is
         *        "dynamodb.amazonaws.com".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The type of the identity. For Time To Live, the type is "Service".
         * </p>
         * 
         * @param type
         *        The type of the identity. For Time To Live, the type is "Service".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String principalId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Identity model) {
            principalId(model.principalId);
            type(model.type);
        }

        public final String getPrincipalId() {
            return principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Identity build() {
            return new Identity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
