/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactGetItemsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<TransactGetItemsResponse.Builder, TransactGetItemsResponse> {
    private static final SdkField<List<ConsumedCapacity>> CONSUMED_CAPACITY_FIELD = SdkField
            .<List<ConsumedCapacity>> builder(MarshallingType.LIST)
            .getter(getter(TransactGetItemsResponse::consumedCapacity))
            .setter(setter(Builder::consumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConsumedCapacity> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConsumedCapacity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ItemResponse>> RESPONSES_FIELD = SdkField
            .<List<ItemResponse>> builder(MarshallingType.LIST)
            .getter(getter(TransactGetItemsResponse::responses))
            .setter(setter(Builder::responses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Responses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ItemResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(ItemResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMED_CAPACITY_FIELD,
            RESPONSES_FIELD));

    private final List<ConsumedCapacity> consumedCapacity;

    private final List<ItemResponse> responses;

    private TransactGetItemsResponse(BuilderImpl builder) {
        super(builder);
        this.consumedCapacity = builder.consumedCapacity;
        this.responses = builder.responses;
    }

    /**
     * <p>
     * If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this is an array of
     * <code>ConsumedCapacity</code> objects, one for each table addressed by <code>TransactGetItem</code> objects in
     * the <i>TransactItems</i> parameter. These <code>ConsumedCapacity</code> objects report the read-capacity units
     * consumed by the <code>TransactGetItems</code> call in that table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this is an array of
     *         <code>ConsumedCapacity</code> objects, one for each table addressed by <code>TransactGetItem</code>
     *         objects in the <i>TransactItems</i> parameter. These <code>ConsumedCapacity</code> objects report the
     *         read-capacity units consumed by the <code>TransactGetItems</code> call in that table.
     */
    public List<ConsumedCapacity> consumedCapacity() {
        return consumedCapacity;
    }

    /**
     * <p>
     * An ordered array of up to 10 <code>ItemResponse</code> objects, each of which corresponds to the
     * <code>TransactGetItem</code> object in the same position in the <i>TransactItems</i> array. Each
     * <code>ItemResponse</code> object contains a Map of the name-value pairs that are the projected attributes of the
     * requested item.
     * </p>
     * <p>
     * If a requested item could not be retrieved, the corresponding <code>ItemResponse</code> object is Null, or if the
     * requested item has no projected attributes, the corresponding <code>ItemResponse</code> object is an empty Map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An ordered array of up to 10 <code>ItemResponse</code> objects, each of which corresponds to the
     *         <code>TransactGetItem</code> object in the same position in the <i>TransactItems</i> array. Each
     *         <code>ItemResponse</code> object contains a Map of the name-value pairs that are the projected attributes
     *         of the requested item.</p>
     *         <p>
     *         If a requested item could not be retrieved, the corresponding <code>ItemResponse</code> object is Null,
     *         or if the requested item has no projected attributes, the corresponding <code>ItemResponse</code> object
     *         is an empty Map.
     */
    public List<ItemResponse> responses() {
        return responses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(responses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactGetItemsResponse)) {
            return false;
        }
        TransactGetItemsResponse other = (TransactGetItemsResponse) obj;
        return Objects.equals(consumedCapacity(), other.consumedCapacity()) && Objects.equals(responses(), other.responses());
    }

    @Override
    public String toString() {
        return ToString.builder("TransactGetItemsResponse").add("ConsumedCapacity", consumedCapacity())
                .add("Responses", responses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumedCapacity":
            return Optional.ofNullable(clazz.cast(consumedCapacity()));
        case "Responses":
            return Optional.ofNullable(clazz.cast(responses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactGetItemsResponse, T> g) {
        return obj -> g.apply((TransactGetItemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, TransactGetItemsResponse> {
        /**
         * <p>
         * If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this is an array of
         * <code>ConsumedCapacity</code> objects, one for each table addressed by <code>TransactGetItem</code> objects
         * in the <i>TransactItems</i> parameter. These <code>ConsumedCapacity</code> objects report the read-capacity
         * units consumed by the <code>TransactGetItems</code> call in that table.
         * </p>
         * 
         * @param consumedCapacity
         *        If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this is an array of
         *        <code>ConsumedCapacity</code> objects, one for each table addressed by <code>TransactGetItem</code>
         *        objects in the <i>TransactItems</i> parameter. These <code>ConsumedCapacity</code> objects report the
         *        read-capacity units consumed by the <code>TransactGetItems</code> call in that table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity);

        /**
         * <p>
         * If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this is an array of
         * <code>ConsumedCapacity</code> objects, one for each table addressed by <code>TransactGetItem</code> objects
         * in the <i>TransactItems</i> parameter. These <code>ConsumedCapacity</code> objects report the read-capacity
         * units consumed by the <code>TransactGetItems</code> call in that table.
         * </p>
         * 
         * @param consumedCapacity
         *        If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this is an array of
         *        <code>ConsumedCapacity</code> objects, one for each table addressed by <code>TransactGetItem</code>
         *        objects in the <i>TransactItems</i> parameter. These <code>ConsumedCapacity</code> objects report the
         *        read-capacity units consumed by the <code>TransactGetItems</code> call in that table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity... consumedCapacity);

        /**
         * <p>
         * If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this is an array of
         * <code>ConsumedCapacity</code> objects, one for each table addressed by <code>TransactGetItem</code> objects
         * in the <i>TransactItems</i> parameter. These <code>ConsumedCapacity</code> objects report the read-capacity
         * units consumed by the <code>TransactGetItems</code> call in that table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConsumedCapacity>.Builder} avoiding the
         * need to create one manually via {@link List<ConsumedCapacity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConsumedCapacity>.Builder#build()} is called immediately and
         * its result is passed to {@link #consumedCapacity(List<ConsumedCapacity>)}.
         * 
         * @param consumedCapacity
         *        a consumer that will call methods on {@link List<ConsumedCapacity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedCapacity(List<ConsumedCapacity>)
         */
        Builder consumedCapacity(Consumer<ConsumedCapacity.Builder>... consumedCapacity);

        /**
         * <p>
         * An ordered array of up to 10 <code>ItemResponse</code> objects, each of which corresponds to the
         * <code>TransactGetItem</code> object in the same position in the <i>TransactItems</i> array. Each
         * <code>ItemResponse</code> object contains a Map of the name-value pairs that are the projected attributes of
         * the requested item.
         * </p>
         * <p>
         * If a requested item could not be retrieved, the corresponding <code>ItemResponse</code> object is Null, or if
         * the requested item has no projected attributes, the corresponding <code>ItemResponse</code> object is an
         * empty Map.
         * </p>
         * 
         * @param responses
         *        An ordered array of up to 10 <code>ItemResponse</code> objects, each of which corresponds to the
         *        <code>TransactGetItem</code> object in the same position in the <i>TransactItems</i> array. Each
         *        <code>ItemResponse</code> object contains a Map of the name-value pairs that are the projected
         *        attributes of the requested item.</p>
         *        <p>
         *        If a requested item could not be retrieved, the corresponding <code>ItemResponse</code> object is
         *        Null, or if the requested item has no projected attributes, the corresponding
         *        <code>ItemResponse</code> object is an empty Map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(Collection<ItemResponse> responses);

        /**
         * <p>
         * An ordered array of up to 10 <code>ItemResponse</code> objects, each of which corresponds to the
         * <code>TransactGetItem</code> object in the same position in the <i>TransactItems</i> array. Each
         * <code>ItemResponse</code> object contains a Map of the name-value pairs that are the projected attributes of
         * the requested item.
         * </p>
         * <p>
         * If a requested item could not be retrieved, the corresponding <code>ItemResponse</code> object is Null, or if
         * the requested item has no projected attributes, the corresponding <code>ItemResponse</code> object is an
         * empty Map.
         * </p>
         * 
         * @param responses
         *        An ordered array of up to 10 <code>ItemResponse</code> objects, each of which corresponds to the
         *        <code>TransactGetItem</code> object in the same position in the <i>TransactItems</i> array. Each
         *        <code>ItemResponse</code> object contains a Map of the name-value pairs that are the projected
         *        attributes of the requested item.</p>
         *        <p>
         *        If a requested item could not be retrieved, the corresponding <code>ItemResponse</code> object is
         *        Null, or if the requested item has no projected attributes, the corresponding
         *        <code>ItemResponse</code> object is an empty Map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(ItemResponse... responses);

        /**
         * <p>
         * An ordered array of up to 10 <code>ItemResponse</code> objects, each of which corresponds to the
         * <code>TransactGetItem</code> object in the same position in the <i>TransactItems</i> array. Each
         * <code>ItemResponse</code> object contains a Map of the name-value pairs that are the projected attributes of
         * the requested item.
         * </p>
         * <p>
         * If a requested item could not be retrieved, the corresponding <code>ItemResponse</code> object is Null, or if
         * the requested item has no projected attributes, the corresponding <code>ItemResponse</code> object is an
         * empty Map.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ItemResponse>.Builder} avoiding the need to
         * create one manually via {@link List<ItemResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ItemResponse>.Builder#build()} is called immediately and its
         * result is passed to {@link #responses(List<ItemResponse>)}.
         * 
         * @param responses
         *        a consumer that will call methods on {@link List<ItemResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responses(List<ItemResponse>)
         */
        Builder responses(Consumer<ItemResponse.Builder>... responses);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<ConsumedCapacity> consumedCapacity = DefaultSdkAutoConstructList.getInstance();

        private List<ItemResponse> responses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransactGetItemsResponse model) {
            super(model);
            consumedCapacity(model.consumedCapacity);
            responses(model.responses);
        }

        public final Collection<ConsumedCapacity.Builder> getConsumedCapacity() {
            return consumedCapacity != null ? consumedCapacity.stream().map(ConsumedCapacity::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity... consumedCapacity) {
            consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder>... consumedCapacity) {
            consumedCapacity(Stream.of(consumedCapacity).map(c -> ConsumedCapacity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        public final Collection<ItemResponse.Builder> getResponses() {
            return responses != null ? responses.stream().map(ItemResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responses(Collection<ItemResponse> responses) {
            this.responses = ItemResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(ItemResponse... responses) {
            responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(Consumer<ItemResponse.Builder>... responses) {
            responses(Stream.of(responses).map(c -> ItemResponse.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResponses(Collection<ItemResponse.BuilderImpl> responses) {
            this.responses = ItemResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        public TransactGetItemsResponse build() {
            return new TransactGetItemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
