/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to perform an <code>UpdateItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Update implements SdkPojo, Serializable, ToCopyableBuilder<Update.Builder, Update> {
    private static final SdkField<Map<String, AttributeValue>> KEY_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .getter(getter(Update::key))
            .setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Update::updateExpression)).setter(setter(Builder::updateExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateExpression").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Update::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Update::conditionExpression)).setter(setter(Builder::conditionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpression").build())
            .build();

    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Update::expressionAttributeNames))
            .setter(setter(Builder::expressionAttributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .getter(getter(Update::expressionAttributeValues))
            .setter(setter(Builder::expressionAttributeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Update::returnValuesOnConditionCheckFailureAsString))
            .setter(setter(Builder::returnValuesOnConditionCheckFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReturnValuesOnConditionCheckFailure").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD,
            UPDATE_EXPRESSION_FIELD, TABLE_NAME_FIELD, CONDITION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD,
            EXPRESSION_ATTRIBUTE_VALUES_FIELD, RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, AttributeValue> key;

    private final String updateExpression;

    private final String tableName;

    private final String conditionExpression;

    private final Map<String, String> expressionAttributeNames;

    private final Map<String, AttributeValue> expressionAttributeValues;

    private final String returnValuesOnConditionCheckFailure;

    private Update(BuilderImpl builder) {
        this.key = builder.key;
        this.updateExpression = builder.updateExpression;
        this.tableName = builder.tableName;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
        this.returnValuesOnConditionCheckFailure = builder.returnValuesOnConditionCheckFailure;
    }

    /**
     * <p>
     * The primary key of the item to be updated. Each element consists of an attribute name and a value for that
     * attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The primary key of the item to be updated. Each element consists of an attribute name and a value for
     *         that attribute.
     */
    public Map<String, AttributeValue> key() {
        return key;
    }

    /**
     * <p>
     * An expression that defines one or more attributes to be updated, the action to be performed on them, and new
     * value(s) for them.
     * </p>
     * 
     * @return An expression that defines one or more attributes to be updated, the action to be performed on them, and
     *         new value(s) for them.
     */
    public String updateExpression() {
        return updateExpression;
    }

    /**
     * <p>
     * Name of the table for the <code>UpdateItem</code> request.
     * </p>
     * 
     * @return Name of the table for the <code>UpdateItem</code> request.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A condition that must be satisfied in order for a conditional update to succeed.
     * </p>
     * 
     * @return A condition that must be satisfied in order for a conditional update to succeed.
     */
    public String conditionExpression() {
        return conditionExpression;
    }

    /**
     * <p>
     * One or more substitution tokens for attribute names in an expression.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more substitution tokens for attribute names in an expression.
     */
    public Map<String, String> expressionAttributeNames() {
        return expressionAttributeNames;
    }

    /**
     * <p>
     * One or more values that can be substituted in an expression.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more values that can be substituted in an expression.
     */
    public Map<String, AttributeValue> expressionAttributeValues() {
        return expressionAttributeValues;
    }

    /**
     * <p>
     * Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Update</code>
     * condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE, ALL_OLD,
     * UPDATED_OLD, ALL_NEW, UPDATED_NEW.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnValuesOnConditionCheckFailure} will return
     * {@link ReturnValuesOnConditionCheckFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #returnValuesOnConditionCheckFailureAsString}.
     * </p>
     * 
     * @return Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the
     *         <code>Update</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid
     *         values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.
     * @see ReturnValuesOnConditionCheckFailure
     */
    public ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure() {
        return ReturnValuesOnConditionCheckFailure.fromValue(returnValuesOnConditionCheckFailure);
    }

    /**
     * <p>
     * Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Update</code>
     * condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE, ALL_OLD,
     * UPDATED_OLD, ALL_NEW, UPDATED_NEW.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnValuesOnConditionCheckFailure} will return
     * {@link ReturnValuesOnConditionCheckFailure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #returnValuesOnConditionCheckFailureAsString}.
     * </p>
     * 
     * @return Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the
     *         <code>Update</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid
     *         values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.
     * @see ReturnValuesOnConditionCheckFailure
     */
    public String returnValuesOnConditionCheckFailureAsString() {
        return returnValuesOnConditionCheckFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(updateExpression());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeValues());
        hashCode = 31 * hashCode + Objects.hashCode(returnValuesOnConditionCheckFailureAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Update)) {
            return false;
        }
        Update other = (Update) obj;
        return Objects.equals(key(), other.key())
                && Objects.equals(updateExpression(), other.updateExpression())
                && Objects.equals(tableName(), other.tableName())
                && Objects.equals(conditionExpression(), other.conditionExpression())
                && Objects.equals(expressionAttributeNames(), other.expressionAttributeNames())
                && Objects.equals(expressionAttributeValues(), other.expressionAttributeValues())
                && Objects.equals(returnValuesOnConditionCheckFailureAsString(),
                        other.returnValuesOnConditionCheckFailureAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("Update").add("Key", key()).add("UpdateExpression", updateExpression())
                .add("TableName", tableName()).add("ConditionExpression", conditionExpression())
                .add("ExpressionAttributeNames", expressionAttributeNames())
                .add("ExpressionAttributeValues", expressionAttributeValues())
                .add("ReturnValuesOnConditionCheckFailure", returnValuesOnConditionCheckFailureAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "UpdateExpression":
            return Optional.ofNullable(clazz.cast(updateExpression()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "ConditionExpression":
            return Optional.ofNullable(clazz.cast(conditionExpression()));
        case "ExpressionAttributeNames":
            return Optional.ofNullable(clazz.cast(expressionAttributeNames()));
        case "ExpressionAttributeValues":
            return Optional.ofNullable(clazz.cast(expressionAttributeValues()));
        case "ReturnValuesOnConditionCheckFailure":
            return Optional.ofNullable(clazz.cast(returnValuesOnConditionCheckFailureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Update, T> g) {
        return obj -> g.apply((Update) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Update> {
        /**
         * <p>
         * The primary key of the item to be updated. Each element consists of an attribute name and a value for that
         * attribute.
         * </p>
         * 
         * @param key
         *        The primary key of the item to be updated. Each element consists of an attribute name and a value for
         *        that attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(Map<String, AttributeValue> key);

        /**
         * <p>
         * An expression that defines one or more attributes to be updated, the action to be performed on them, and new
         * value(s) for them.
         * </p>
         * 
         * @param updateExpression
         *        An expression that defines one or more attributes to be updated, the action to be performed on them,
         *        and new value(s) for them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateExpression(String updateExpression);

        /**
         * <p>
         * Name of the table for the <code>UpdateItem</code> request.
         * </p>
         * 
         * @param tableName
         *        Name of the table for the <code>UpdateItem</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A condition that must be satisfied in order for a conditional update to succeed.
         * </p>
         * 
         * @param conditionExpression
         *        A condition that must be satisfied in order for a conditional update to succeed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionExpression(String conditionExpression);

        /**
         * <p>
         * One or more substitution tokens for attribute names in an expression.
         * </p>
         * 
         * @param expressionAttributeNames
         *        One or more substitution tokens for attribute names in an expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeNames(Map<String, String> expressionAttributeNames);

        /**
         * <p>
         * One or more values that can be substituted in an expression.
         * </p>
         * 
         * @param expressionAttributeValues
         *        One or more values that can be substituted in an expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues);

        /**
         * <p>
         * Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Update</code>
         * condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE, ALL_OLD,
         * UPDATED_OLD, ALL_NEW, UPDATED_NEW.
         * </p>
         * 
         * @param returnValuesOnConditionCheckFailure
         *        Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the
         *        <code>Update</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid
         *        values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.
         * @see ReturnValuesOnConditionCheckFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValuesOnConditionCheckFailure
         */
        Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure);

        /**
         * <p>
         * Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Update</code>
         * condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE, ALL_OLD,
         * UPDATED_OLD, ALL_NEW, UPDATED_NEW.
         * </p>
         * 
         * @param returnValuesOnConditionCheckFailure
         *        Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the
         *        <code>Update</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid
         *        values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.
         * @see ReturnValuesOnConditionCheckFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValuesOnConditionCheckFailure
         */
        Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AttributeValue> key = DefaultSdkAutoConstructMap.getInstance();

        private String updateExpression;

        private String tableName;

        private String conditionExpression;

        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();

        private String returnValuesOnConditionCheckFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(Update model) {
            key(model.key);
            updateExpression(model.updateExpression);
            tableName(model.tableName);
            conditionExpression(model.conditionExpression);
            expressionAttributeNames(model.expressionAttributeNames);
            expressionAttributeValues(model.expressionAttributeValues);
            returnValuesOnConditionCheckFailure(model.returnValuesOnConditionCheckFailure);
        }

        public final Map<String, AttributeValue.Builder> getKey() {
            return key != null ? CollectionUtils.mapValues(key, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue.BuilderImpl> key) {
            this.key = KeyCopier.copyFromBuilder(key);
        }

        public final String getUpdateExpression() {
            return updateExpression;
        }

        @Override
        public final Builder updateExpression(String updateExpression) {
            this.updateExpression = updateExpression;
            return this;
        }

        public final void setUpdateExpression(String updateExpression) {
            this.updateExpression = updateExpression;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getConditionExpression() {
            return conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return expressionAttributeValues != null ? CollectionUtils.mapValues(expressionAttributeValues,
                    AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        public final String getReturnValuesOnConditionCheckFailure() {
            return returnValuesOnConditionCheckFailure;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
            return this;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(
                ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure.toString());
            return this;
        }

        public final void setReturnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
        }

        @Override
        public Update build() {
            return new Update(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
