/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.SSEStatus;
import software.amazon.awssdk.services.dynamodb.model.SSEType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SSEDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SSEDescription> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SSEDescription.getter(SSEDescription::statusAsString)).setter(SSEDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SSEDescription.getter(SSEDescription::sseTypeAsString)).setter(SSEDescription.setter(Builder::sseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEType").build()}).build();
    private static final SdkField<String> KMS_MASTER_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SSEDescription.getter(SSEDescription::kmsMasterKeyArn)).setter(SSEDescription.setter(Builder::kmsMasterKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SSE_TYPE_FIELD, KMS_MASTER_KEY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String sseType;
    private final String kmsMasterKeyArn;

    private SSEDescription(BuilderImpl builder) {
        this.status = builder.status;
        this.sseType = builder.sseType;
        this.kmsMasterKeyArn = builder.kmsMasterKeyArn;
    }

    public SSEStatus status() {
        return SSEStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public SSEType sseType() {
        return SSEType.fromValue(this.sseType);
    }

    public String sseTypeAsString() {
        return this.sseType;
    }

    public String kmsMasterKeyArn() {
        return this.kmsMasterKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSEDescription)) {
            return false;
        }
        SSEDescription other = (SSEDescription)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sseTypeAsString(), other.sseTypeAsString()) && Objects.equals(this.kmsMasterKeyArn(), other.kmsMasterKeyArn());
    }

    public String toString() {
        return ToString.builder((String)"SSEDescription").add("Status", (Object)this.statusAsString()).add("SSEType", (Object)this.sseTypeAsString()).add("KMSMasterKeyArn", (Object)this.kmsMasterKeyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SSEType": {
                return Optional.ofNullable(clazz.cast(this.sseTypeAsString()));
            }
            case "KMSMasterKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SSEDescription, T> g) {
        return obj -> g.apply((SSEDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String sseType;
        private String kmsMasterKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SSEDescription model) {
            this.status(model.status);
            this.sseType(model.sseType);
            this.kmsMasterKeyArn(model.kmsMasterKeyArn);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SSEStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSseTypeAsString() {
            return this.sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType == null ? null : sseType.toString());
            return this;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        public final String getKmsMasterKeyArn() {
            return this.kmsMasterKeyArn;
        }

        @Override
        public final Builder kmsMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
            return this;
        }

        public final void setKmsMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
        }

        public SSEDescription build() {
            return new SSEDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SSEDescription> {
        public Builder status(String var1);

        public Builder status(SSEStatus var1);

        public Builder sseType(String var1);

        public Builder sseType(SSEType var1);

        public Builder kmsMasterKeyArn(String var1);
    }
}

