/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Replica-specific provisioned throughput settings. If not specified, uses the source table's provisioned throughput
 * settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedThroughputOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedThroughputOverride.Builder, ProvisionedThroughputOverride> {
    private static final SdkField<Long> READ_CAPACITY_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ProvisionedThroughputOverride::readCapacityUnits)).setter(setter(Builder::readCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadCapacityUnits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_CAPACITY_UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long readCapacityUnits;

    private ProvisionedThroughputOverride(BuilderImpl builder) {
        this.readCapacityUnits = builder.readCapacityUnits;
    }

    /**
     * <p>
     * Replica-specific read capacity units. If not specified, uses the source table's read capacity settings.
     * </p>
     * 
     * @return Replica-specific read capacity units. If not specified, uses the source table's read capacity settings.
     */
    public Long readCapacityUnits() {
        return readCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readCapacityUnits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedThroughputOverride)) {
            return false;
        }
        ProvisionedThroughputOverride other = (ProvisionedThroughputOverride) obj;
        return Objects.equals(readCapacityUnits(), other.readCapacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProvisionedThroughputOverride").add("ReadCapacityUnits", readCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(readCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedThroughputOverride, T> g) {
        return obj -> g.apply((ProvisionedThroughputOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedThroughputOverride> {
        /**
         * <p>
         * Replica-specific read capacity units. If not specified, uses the source table's read capacity settings.
         * </p>
         * 
         * @param readCapacityUnits
         *        Replica-specific read capacity units. If not specified, uses the source table's read capacity
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityUnits(Long readCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private Long readCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughputOverride model) {
            readCapacityUnits(model.readCapacityUnits);
        }

        public final Long getReadCapacityUnits() {
            return readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        public ProvisionedThroughputOverride build() {
            return new ProvisionedThroughputOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
