/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContributorInsightsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<ListContributorInsightsResponse.Builder, ListContributorInsightsResponse> {
    private static final SdkField<List<ContributorInsightsSummary>> CONTRIBUTOR_INSIGHTS_SUMMARIES_FIELD = SdkField
            .<List<ContributorInsightsSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListContributorInsightsResponse::contributorInsightsSummaries))
            .setter(setter(Builder::contributorInsightsSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContributorInsightsSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContributorInsightsSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListContributorInsightsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTRIBUTOR_INSIGHTS_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ContributorInsightsSummary> contributorInsightsSummaries;

    private final String nextToken;

    private ListContributorInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.contributorInsightsSummaries = builder.contributorInsightsSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of ContributorInsightsSummary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of ContributorInsightsSummary.
     */
    public List<ContributorInsightsSummary> contributorInsightsSummaries() {
        return contributorInsightsSummaries;
    }

    /**
     * <p>
     * A token to go to the next page if there is one.
     * </p>
     * 
     * @return A token to go to the next page if there is one.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contributorInsightsSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContributorInsightsResponse)) {
            return false;
        }
        ListContributorInsightsResponse other = (ListContributorInsightsResponse) obj;
        return Objects.equals(contributorInsightsSummaries(), other.contributorInsightsSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListContributorInsightsResponse")
                .add("ContributorInsightsSummaries", contributorInsightsSummaries()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContributorInsightsSummaries":
            return Optional.ofNullable(clazz.cast(contributorInsightsSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContributorInsightsResponse, T> g) {
        return obj -> g.apply((ListContributorInsightsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListContributorInsightsResponse> {
        /**
         * <p>
         * A list of ContributorInsightsSummary.
         * </p>
         * 
         * @param contributorInsightsSummaries
         *        A list of ContributorInsightsSummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributorInsightsSummaries(Collection<ContributorInsightsSummary> contributorInsightsSummaries);

        /**
         * <p>
         * A list of ContributorInsightsSummary.
         * </p>
         * 
         * @param contributorInsightsSummaries
         *        A list of ContributorInsightsSummary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributorInsightsSummaries(ContributorInsightsSummary... contributorInsightsSummaries);

        /**
         * <p>
         * A list of ContributorInsightsSummary.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContributorInsightsSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ContributorInsightsSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContributorInsightsSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #contributorInsightsSummaries(List<ContributorInsightsSummary>)}.
         * 
         * @param contributorInsightsSummaries
         *        a consumer that will call methods on {@link List<ContributorInsightsSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contributorInsightsSummaries(List<ContributorInsightsSummary>)
         */
        Builder contributorInsightsSummaries(Consumer<ContributorInsightsSummary.Builder>... contributorInsightsSummaries);

        /**
         * <p>
         * A token to go to the next page if there is one.
         * </p>
         * 
         * @param nextToken
         *        A token to go to the next page if there is one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<ContributorInsightsSummary> contributorInsightsSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContributorInsightsResponse model) {
            super(model);
            contributorInsightsSummaries(model.contributorInsightsSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<ContributorInsightsSummary.Builder> getContributorInsightsSummaries() {
            return contributorInsightsSummaries != null ? contributorInsightsSummaries.stream()
                    .map(ContributorInsightsSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contributorInsightsSummaries(Collection<ContributorInsightsSummary> contributorInsightsSummaries) {
            this.contributorInsightsSummaries = ContributorInsightsSummariesCopier.copy(contributorInsightsSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributorInsightsSummaries(ContributorInsightsSummary... contributorInsightsSummaries) {
            contributorInsightsSummaries(Arrays.asList(contributorInsightsSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributorInsightsSummaries(
                Consumer<ContributorInsightsSummary.Builder>... contributorInsightsSummaries) {
            contributorInsightsSummaries(Stream.of(contributorInsightsSummaries)
                    .map(c -> ContributorInsightsSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContributorInsightsSummaries(
                Collection<ContributorInsightsSummary.BuilderImpl> contributorInsightsSummaries) {
            this.contributorInsightsSummaries = ContributorInsightsSummariesCopier.copyFromBuilder(contributorInsightsSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListContributorInsightsResponse build() {
            return new ListContributorInsightsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
