/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactWriteItemsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<TransactWriteItemsResponse.Builder, TransactWriteItemsResponse> {
    private static final SdkField<List<ConsumedCapacity>> CONSUMED_CAPACITY_FIELD = SdkField
            .<List<ConsumedCapacity>> builder(MarshallingType.LIST)
            .getter(getter(TransactWriteItemsResponse::consumedCapacity))
            .setter(setter(Builder::consumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConsumedCapacity> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConsumedCapacity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<ItemCollectionMetrics>>> ITEM_COLLECTION_METRICS_FIELD = SdkField
            .<Map<String, List<ItemCollectionMetrics>>> builder(MarshallingType.MAP)
            .getter(getter(TransactWriteItemsResponse::itemCollectionMetrics))
            .setter(setter(Builder::itemCollectionMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCollectionMetrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ItemCollectionMetrics>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ItemCollectionMetrics> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(ItemCollectionMetrics::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMED_CAPACITY_FIELD,
            ITEM_COLLECTION_METRICS_FIELD));

    private final List<ConsumedCapacity> consumedCapacity;

    private final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;

    private TransactWriteItemsResponse(BuilderImpl builder) {
        super(builder);
        this.consumedCapacity = builder.consumedCapacity;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
    }

    /**
     * Returns true if the ConsumedCapacity property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConsumedCapacity() {
        return consumedCapacity != null && !(consumedCapacity instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity units consumed by the entire <code>TransactWriteItems</code> operation. The values of the list are
     * ordered according to the ordering of the <code>TransactItems</code> request parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConsumedCapacity()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The capacity units consumed by the entire <code>TransactWriteItems</code> operation. The values of the
     *         list are ordered according to the ordering of the <code>TransactItems</code> request parameter.
     */
    public List<ConsumedCapacity> consumedCapacity() {
        return consumedCapacity;
    }

    /**
     * Returns true if the ItemCollectionMetrics property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasItemCollectionMetrics() {
        return itemCollectionMetrics != null && !(itemCollectionMetrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tables that were processed by <code>TransactWriteItems</code> and, for each table, information about
     * any item collections that were affected by individual <code>UpdateItem</code>, <code>PutItem</code>, or
     * <code>DeleteItem</code> operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItemCollectionMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tables that were processed by <code>TransactWriteItems</code> and, for each table, information
     *         about any item collections that were affected by individual <code>UpdateItem</code>, <code>PutItem</code>
     *         , or <code>DeleteItem</code> operations.
     */
    public Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics() {
        return itemCollectionMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(itemCollectionMetrics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactWriteItemsResponse)) {
            return false;
        }
        TransactWriteItemsResponse other = (TransactWriteItemsResponse) obj;
        return Objects.equals(consumedCapacity(), other.consumedCapacity())
                && Objects.equals(itemCollectionMetrics(), other.itemCollectionMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransactWriteItemsResponse").add("ConsumedCapacity", consumedCapacity())
                .add("ItemCollectionMetrics", itemCollectionMetrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumedCapacity":
            return Optional.ofNullable(clazz.cast(consumedCapacity()));
        case "ItemCollectionMetrics":
            return Optional.ofNullable(clazz.cast(itemCollectionMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactWriteItemsResponse, T> g) {
        return obj -> g.apply((TransactWriteItemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, TransactWriteItemsResponse> {
        /**
         * <p>
         * The capacity units consumed by the entire <code>TransactWriteItems</code> operation. The values of the list
         * are ordered according to the ordering of the <code>TransactItems</code> request parameter.
         * </p>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the entire <code>TransactWriteItems</code> operation. The values of the
         *        list are ordered according to the ordering of the <code>TransactItems</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity);

        /**
         * <p>
         * The capacity units consumed by the entire <code>TransactWriteItems</code> operation. The values of the list
         * are ordered according to the ordering of the <code>TransactItems</code> request parameter.
         * </p>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the entire <code>TransactWriteItems</code> operation. The values of the
         *        list are ordered according to the ordering of the <code>TransactItems</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity... consumedCapacity);

        /**
         * <p>
         * The capacity units consumed by the entire <code>TransactWriteItems</code> operation. The values of the list
         * are ordered according to the ordering of the <code>TransactItems</code> request parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConsumedCapacity>.Builder} avoiding the
         * need to create one manually via {@link List<ConsumedCapacity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConsumedCapacity>.Builder#build()} is called immediately and
         * its result is passed to {@link #consumedCapacity(List<ConsumedCapacity>)}.
         * 
         * @param consumedCapacity
         *        a consumer that will call methods on {@link List<ConsumedCapacity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedCapacity(List<ConsumedCapacity>)
         */
        Builder consumedCapacity(Consumer<ConsumedCapacity.Builder>... consumedCapacity);

        /**
         * <p>
         * A list of tables that were processed by <code>TransactWriteItems</code> and, for each table, information
         * about any item collections that were affected by individual <code>UpdateItem</code>, <code>PutItem</code>, or
         * <code>DeleteItem</code> operations.
         * </p>
         * 
         * @param itemCollectionMetrics
         *        A list of tables that were processed by <code>TransactWriteItems</code> and, for each table,
         *        information about any item collections that were affected by individual <code>UpdateItem</code>,
         *        <code>PutItem</code>, or <code>DeleteItem</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<ConsumedCapacity> consumedCapacity = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransactWriteItemsResponse model) {
            super(model);
            consumedCapacity(model.consumedCapacity);
            itemCollectionMetrics(model.itemCollectionMetrics);
        }

        public final Collection<ConsumedCapacity.Builder> getConsumedCapacity() {
            return consumedCapacity != null ? consumedCapacity.stream().map(ConsumedCapacity::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity... consumedCapacity) {
            consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder>... consumedCapacity) {
            consumedCapacity(Stream.of(consumedCapacity).map(c -> ConsumedCapacity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        public final Map<String, ? extends Collection<ItemCollectionMetrics>> getItemCollectionMetrics() {
            return itemCollectionMetrics;
        }

        @Override
        public final Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
            return this;
        }

        public final void setItemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
        }

        @Override
        public TransactWriteItemsResponse build() {
            return new TransactWriteItemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
