/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTableFromBackupRequest extends DynamoDbRequest implements
        ToCopyableBuilder<RestoreTableFromBackupRequest.Builder, RestoreTableFromBackupRequest> {
    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreTableFromBackupRequest::targetTableName)).setter(setter(Builder::targetTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()).build();

    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreTableFromBackupRequest::backupArn)).setter(setter(Builder::backupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()).build();

    private static final SdkField<String> BILLING_MODE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreTableFromBackupRequest::billingModeOverrideAsString))
            .setter(setter(Builder::billingModeOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingModeOverride").build())
            .build();

    private static final SdkField<List<GlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD = SdkField
            .<List<GlobalSecondaryIndex>> builder(MarshallingType.LIST)
            .getter(getter(RestoreTableFromBackupRequest::globalSecondaryIndexOverride))
            .setter(setter(Builder::globalSecondaryIndexOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexOverride")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LocalSecondaryIndex>> LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD = SdkField
            .<List<LocalSecondaryIndex>> builder(MarshallingType.LIST)
            .getter(getter(RestoreTableFromBackupRequest::localSecondaryIndexOverride))
            .setter(setter(Builder::localSecondaryIndexOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexOverride")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO)
            .getter(getter(RestoreTableFromBackupRequest::provisionedThroughputOverride))
            .setter(setter(Builder::provisionedThroughputOverride))
            .constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TABLE_NAME_FIELD,
            BACKUP_ARN_FIELD, BILLING_MODE_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD,
            LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD));

    private final String targetTableName;

    private final String backupArn;

    private final String billingModeOverride;

    private final List<GlobalSecondaryIndex> globalSecondaryIndexOverride;

    private final List<LocalSecondaryIndex> localSecondaryIndexOverride;

    private final ProvisionedThroughput provisionedThroughputOverride;

    private RestoreTableFromBackupRequest(BuilderImpl builder) {
        super(builder);
        this.targetTableName = builder.targetTableName;
        this.backupArn = builder.backupArn;
        this.billingModeOverride = builder.billingModeOverride;
        this.globalSecondaryIndexOverride = builder.globalSecondaryIndexOverride;
        this.localSecondaryIndexOverride = builder.localSecondaryIndexOverride;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
    }

    /**
     * <p>
     * The name of the new table to which the backup must be restored.
     * </p>
     * 
     * @return The name of the new table to which the backup must be restored.
     */
    public String targetTableName() {
        return targetTableName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the backup.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the backup.
     */
    public String backupArn() {
        return backupArn;
    }

    /**
     * <p>
     * The billing mode of the restored table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #billingModeOverride} will return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #billingModeOverrideAsString}.
     * </p>
     * 
     * @return The billing mode of the restored table.
     * @see BillingMode
     */
    public BillingMode billingModeOverride() {
        return BillingMode.fromValue(billingModeOverride);
    }

    /**
     * <p>
     * The billing mode of the restored table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #billingModeOverride} will return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #billingModeOverrideAsString}.
     * </p>
     * 
     * @return The billing mode of the restored table.
     * @see BillingMode
     */
    public String billingModeOverrideAsString() {
        return billingModeOverride;
    }

    /**
     * Returns true if the GlobalSecondaryIndexOverride property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasGlobalSecondaryIndexOverride() {
        return globalSecondaryIndexOverride != null && !(globalSecondaryIndexOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of global secondary indexes for the restored table. The indexes provided should match existing secondary
     * indexes. You can choose to exclude some or all of the indexes at the time of restore.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalSecondaryIndexOverride()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of global secondary indexes for the restored table. The indexes provided should match existing
     *         secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
     */
    public List<GlobalSecondaryIndex> globalSecondaryIndexOverride() {
        return globalSecondaryIndexOverride;
    }

    /**
     * Returns true if the LocalSecondaryIndexOverride property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasLocalSecondaryIndexOverride() {
        return localSecondaryIndexOverride != null && !(localSecondaryIndexOverride instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of local secondary indexes for the restored table. The indexes provided should match existing secondary
     * indexes. You can choose to exclude some or all of the indexes at the time of restore.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLocalSecondaryIndexOverride()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of local secondary indexes for the restored table. The indexes provided should match existing
     *         secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
     */
    public List<LocalSecondaryIndex> localSecondaryIndexOverride() {
        return localSecondaryIndexOverride;
    }

    /**
     * <p>
     * Provisioned throughput settings for the restored table.
     * </p>
     * 
     * @return Provisioned throughput settings for the restored table.
     */
    public ProvisionedThroughput provisionedThroughputOverride() {
        return provisionedThroughputOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(billingModeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(globalSecondaryIndexOverride());
        hashCode = 31 * hashCode + Objects.hashCode(localSecondaryIndexOverride());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputOverride());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromBackupRequest)) {
            return false;
        }
        RestoreTableFromBackupRequest other = (RestoreTableFromBackupRequest) obj;
        return Objects.equals(targetTableName(), other.targetTableName()) && Objects.equals(backupArn(), other.backupArn())
                && Objects.equals(billingModeOverrideAsString(), other.billingModeOverrideAsString())
                && Objects.equals(globalSecondaryIndexOverride(), other.globalSecondaryIndexOverride())
                && Objects.equals(localSecondaryIndexOverride(), other.localSecondaryIndexOverride())
                && Objects.equals(provisionedThroughputOverride(), other.provisionedThroughputOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RestoreTableFromBackupRequest").add("TargetTableName", targetTableName())
                .add("BackupArn", backupArn()).add("BillingModeOverride", billingModeOverrideAsString())
                .add("GlobalSecondaryIndexOverride", globalSecondaryIndexOverride())
                .add("LocalSecondaryIndexOverride", localSecondaryIndexOverride())
                .add("ProvisionedThroughputOverride", provisionedThroughputOverride()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetTableName":
            return Optional.ofNullable(clazz.cast(targetTableName()));
        case "BackupArn":
            return Optional.ofNullable(clazz.cast(backupArn()));
        case "BillingModeOverride":
            return Optional.ofNullable(clazz.cast(billingModeOverrideAsString()));
        case "GlobalSecondaryIndexOverride":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexOverride()));
        case "LocalSecondaryIndexOverride":
            return Optional.ofNullable(clazz.cast(localSecondaryIndexOverride()));
        case "ProvisionedThroughputOverride":
            return Optional.ofNullable(clazz.cast(provisionedThroughputOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableFromBackupRequest, T> g) {
        return obj -> g.apply((RestoreTableFromBackupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreTableFromBackupRequest> {
        /**
         * <p>
         * The name of the new table to which the backup must be restored.
         * </p>
         * 
         * @param targetTableName
         *        The name of the new table to which the backup must be restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTableName(String targetTableName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the backup.
         * </p>
         * 
         * @param backupArn
         *        The Amazon Resource Name (ARN) associated with the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupArn(String backupArn);

        /**
         * <p>
         * The billing mode of the restored table.
         * </p>
         * 
         * @param billingModeOverride
         *        The billing mode of the restored table.
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingModeOverride(String billingModeOverride);

        /**
         * <p>
         * The billing mode of the restored table.
         * </p>
         * 
         * @param billingModeOverride
         *        The billing mode of the restored table.
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingModeOverride(BillingMode billingModeOverride);

        /**
         * <p>
         * List of global secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * 
         * @param globalSecondaryIndexOverride
         *        List of global secondary indexes for the restored table. The indexes provided should match existing
         *        secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexOverride(Collection<GlobalSecondaryIndex> globalSecondaryIndexOverride);

        /**
         * <p>
         * List of global secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * 
         * @param globalSecondaryIndexOverride
         *        List of global secondary indexes for the restored table. The indexes provided should match existing
         *        secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexOverride(GlobalSecondaryIndex... globalSecondaryIndexOverride);

        /**
         * <p>
         * List of global secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GlobalSecondaryIndex>.Builder} avoiding the
         * need to create one manually via {@link List<GlobalSecondaryIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlobalSecondaryIndex>.Builder#build()} is called immediately
         * and its result is passed to {@link #globalSecondaryIndexOverride(List<GlobalSecondaryIndex>)}.
         * 
         * @param globalSecondaryIndexOverride
         *        a consumer that will call methods on {@link List<GlobalSecondaryIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexOverride(List<GlobalSecondaryIndex>)
         */
        Builder globalSecondaryIndexOverride(Consumer<GlobalSecondaryIndex.Builder>... globalSecondaryIndexOverride);

        /**
         * <p>
         * List of local secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * 
         * @param localSecondaryIndexOverride
         *        List of local secondary indexes for the restored table. The indexes provided should match existing
         *        secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexOverride(Collection<LocalSecondaryIndex> localSecondaryIndexOverride);

        /**
         * <p>
         * List of local secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * 
         * @param localSecondaryIndexOverride
         *        List of local secondary indexes for the restored table. The indexes provided should match existing
         *        secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexOverride(LocalSecondaryIndex... localSecondaryIndexOverride);

        /**
         * <p>
         * List of local secondary indexes for the restored table. The indexes provided should match existing secondary
         * indexes. You can choose to exclude some or all of the indexes at the time of restore.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LocalSecondaryIndex>.Builder} avoiding the
         * need to create one manually via {@link List<LocalSecondaryIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocalSecondaryIndex>.Builder#build()} is called immediately
         * and its result is passed to {@link #localSecondaryIndexOverride(List<LocalSecondaryIndex>)}.
         * 
         * @param localSecondaryIndexOverride
         *        a consumer that will call methods on {@link List<LocalSecondaryIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localSecondaryIndexOverride(List<LocalSecondaryIndex>)
         */
        Builder localSecondaryIndexOverride(Consumer<LocalSecondaryIndex.Builder>... localSecondaryIndexOverride);

        /**
         * <p>
         * Provisioned throughput settings for the restored table.
         * </p>
         * 
         * @param provisionedThroughputOverride
         *        Provisioned throughput settings for the restored table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputOverride(ProvisionedThroughput provisionedThroughputOverride);

        /**
         * <p>
         * Provisioned throughput settings for the restored table.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding the need
         * to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughputOverride(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughputOverride
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughputOverride(ProvisionedThroughput)
         */
        default Builder provisionedThroughputOverride(Consumer<ProvisionedThroughput.Builder> provisionedThroughputOverride) {
            return provisionedThroughputOverride(ProvisionedThroughput.builder().applyMutation(provisionedThroughputOverride)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String targetTableName;

        private String backupArn;

        private String billingModeOverride;

        private List<GlobalSecondaryIndex> globalSecondaryIndexOverride = DefaultSdkAutoConstructList.getInstance();

        private List<LocalSecondaryIndex> localSecondaryIndexOverride = DefaultSdkAutoConstructList.getInstance();

        private ProvisionedThroughput provisionedThroughputOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromBackupRequest model) {
            super(model);
            targetTableName(model.targetTableName);
            backupArn(model.backupArn);
            billingModeOverride(model.billingModeOverride);
            globalSecondaryIndexOverride(model.globalSecondaryIndexOverride);
            localSecondaryIndexOverride(model.localSecondaryIndexOverride);
            provisionedThroughputOverride(model.provisionedThroughputOverride);
        }

        public final String getTargetTableName() {
            return targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        public final String getBackupArn() {
            return backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        public final String getBillingModeOverrideAsString() {
            return billingModeOverride;
        }

        @Override
        public final Builder billingModeOverride(String billingModeOverride) {
            this.billingModeOverride = billingModeOverride;
            return this;
        }

        @Override
        public final Builder billingModeOverride(BillingMode billingModeOverride) {
            this.billingModeOverride(billingModeOverride == null ? null : billingModeOverride.toString());
            return this;
        }

        public final void setBillingModeOverride(String billingModeOverride) {
            this.billingModeOverride = billingModeOverride;
        }

        public final Collection<GlobalSecondaryIndex.Builder> getGlobalSecondaryIndexOverride() {
            return globalSecondaryIndexOverride != null ? globalSecondaryIndexOverride.stream()
                    .map(GlobalSecondaryIndex::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexOverride(Collection<GlobalSecondaryIndex> globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexOverride(GlobalSecondaryIndex... globalSecondaryIndexOverride) {
            globalSecondaryIndexOverride(Arrays.asList(globalSecondaryIndexOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexOverride(Consumer<GlobalSecondaryIndex.Builder>... globalSecondaryIndexOverride) {
            globalSecondaryIndexOverride(Stream.of(globalSecondaryIndexOverride)
                    .map(c -> GlobalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexOverride(
                Collection<GlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride = GlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexOverride);
        }

        public final Collection<LocalSecondaryIndex.Builder> getLocalSecondaryIndexOverride() {
            return localSecondaryIndexOverride != null ? localSecondaryIndexOverride.stream().map(LocalSecondaryIndex::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localSecondaryIndexOverride(Collection<LocalSecondaryIndex> localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride = LocalSecondaryIndexListCopier.copy(localSecondaryIndexOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexOverride(LocalSecondaryIndex... localSecondaryIndexOverride) {
            localSecondaryIndexOverride(Arrays.asList(localSecondaryIndexOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexOverride(Consumer<LocalSecondaryIndex.Builder>... localSecondaryIndexOverride) {
            localSecondaryIndexOverride(Stream.of(localSecondaryIndexOverride)
                    .map(c -> LocalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalSecondaryIndexOverride(Collection<LocalSecondaryIndex.BuilderImpl> localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride = LocalSecondaryIndexListCopier.copyFromBuilder(localSecondaryIndexOverride);
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughputOverride() {
            return provisionedThroughputOverride != null ? provisionedThroughputOverride.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughput provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughput.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build()
                    : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableFromBackupRequest build() {
            return new RestoreTableFromBackupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
