/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeLimits</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLimitsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DescribeLimitsResponse.Builder, DescribeLimitsResponse> {
    private static final SdkField<Long> ACCOUNT_MAX_READ_CAPACITY_UNITS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeLimitsResponse::accountMaxReadCapacityUnits))
            .setter(setter(Builder::accountMaxReadCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountMaxReadCapacityUnits")
                    .build()).build();

    private static final SdkField<Long> ACCOUNT_MAX_WRITE_CAPACITY_UNITS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeLimitsResponse::accountMaxWriteCapacityUnits))
            .setter(setter(Builder::accountMaxWriteCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountMaxWriteCapacityUnits")
                    .build()).build();

    private static final SdkField<Long> TABLE_MAX_READ_CAPACITY_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeLimitsResponse::tableMaxReadCapacityUnits)).setter(setter(Builder::tableMaxReadCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMaxReadCapacityUnits").build())
            .build();

    private static final SdkField<Long> TABLE_MAX_WRITE_CAPACITY_UNITS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeLimitsResponse::tableMaxWriteCapacityUnits))
            .setter(setter(Builder::tableMaxWriteCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMaxWriteCapacityUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCOUNT_MAX_READ_CAPACITY_UNITS_FIELD, ACCOUNT_MAX_WRITE_CAPACITY_UNITS_FIELD, TABLE_MAX_READ_CAPACITY_UNITS_FIELD,
            TABLE_MAX_WRITE_CAPACITY_UNITS_FIELD));

    private final Long accountMaxReadCapacityUnits;

    private final Long accountMaxWriteCapacityUnits;

    private final Long tableMaxReadCapacityUnits;

    private final Long tableMaxWriteCapacityUnits;

    private DescribeLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.accountMaxReadCapacityUnits = builder.accountMaxReadCapacityUnits;
        this.accountMaxWriteCapacityUnits = builder.accountMaxWriteCapacityUnits;
        this.tableMaxReadCapacityUnits = builder.tableMaxReadCapacityUnits;
        this.tableMaxWriteCapacityUnits = builder.tableMaxWriteCapacityUnits;
    }

    /**
     * <p>
     * The maximum total read capacity units that your account allows you to provision across all of your tables in this
     * Region.
     * </p>
     * 
     * @return The maximum total read capacity units that your account allows you to provision across all of your tables
     *         in this Region.
     */
    public Long accountMaxReadCapacityUnits() {
        return accountMaxReadCapacityUnits;
    }

    /**
     * <p>
     * The maximum total write capacity units that your account allows you to provision across all of your tables in
     * this Region.
     * </p>
     * 
     * @return The maximum total write capacity units that your account allows you to provision across all of your
     *         tables in this Region.
     */
    public Long accountMaxWriteCapacityUnits() {
        return accountMaxWriteCapacityUnits;
    }

    /**
     * <p>
     * The maximum read capacity units that your account allows you to provision for a new table that you are creating
     * in this Region, including the read capacity units provisioned for its global secondary indexes (GSIs).
     * </p>
     * 
     * @return The maximum read capacity units that your account allows you to provision for a new table that you are
     *         creating in this Region, including the read capacity units provisioned for its global secondary indexes
     *         (GSIs).
     */
    public Long tableMaxReadCapacityUnits() {
        return tableMaxReadCapacityUnits;
    }

    /**
     * <p>
     * The maximum write capacity units that your account allows you to provision for a new table that you are creating
     * in this Region, including the write capacity units provisioned for its global secondary indexes (GSIs).
     * </p>
     * 
     * @return The maximum write capacity units that your account allows you to provision for a new table that you are
     *         creating in this Region, including the write capacity units provisioned for its global secondary indexes
     *         (GSIs).
     */
    public Long tableMaxWriteCapacityUnits() {
        return tableMaxWriteCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountMaxReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(accountMaxWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(tableMaxReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(tableMaxWriteCapacityUnits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLimitsResponse)) {
            return false;
        }
        DescribeLimitsResponse other = (DescribeLimitsResponse) obj;
        return Objects.equals(accountMaxReadCapacityUnits(), other.accountMaxReadCapacityUnits())
                && Objects.equals(accountMaxWriteCapacityUnits(), other.accountMaxWriteCapacityUnits())
                && Objects.equals(tableMaxReadCapacityUnits(), other.tableMaxReadCapacityUnits())
                && Objects.equals(tableMaxWriteCapacityUnits(), other.tableMaxWriteCapacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLimitsResponse").add("AccountMaxReadCapacityUnits", accountMaxReadCapacityUnits())
                .add("AccountMaxWriteCapacityUnits", accountMaxWriteCapacityUnits())
                .add("TableMaxReadCapacityUnits", tableMaxReadCapacityUnits())
                .add("TableMaxWriteCapacityUnits", tableMaxWriteCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountMaxReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(accountMaxReadCapacityUnits()));
        case "AccountMaxWriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(accountMaxWriteCapacityUnits()));
        case "TableMaxReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(tableMaxReadCapacityUnits()));
        case "TableMaxWriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(tableMaxWriteCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLimitsResponse, T> g) {
        return obj -> g.apply((DescribeLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLimitsResponse> {
        /**
         * <p>
         * The maximum total read capacity units that your account allows you to provision across all of your tables in
         * this Region.
         * </p>
         * 
         * @param accountMaxReadCapacityUnits
         *        The maximum total read capacity units that your account allows you to provision across all of your
         *        tables in this Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits);

        /**
         * <p>
         * The maximum total write capacity units that your account allows you to provision across all of your tables in
         * this Region.
         * </p>
         * 
         * @param accountMaxWriteCapacityUnits
         *        The maximum total write capacity units that your account allows you to provision across all of your
         *        tables in this Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits);

        /**
         * <p>
         * The maximum read capacity units that your account allows you to provision for a new table that you are
         * creating in this Region, including the read capacity units provisioned for its global secondary indexes
         * (GSIs).
         * </p>
         * 
         * @param tableMaxReadCapacityUnits
         *        The maximum read capacity units that your account allows you to provision for a new table that you are
         *        creating in this Region, including the read capacity units provisioned for its global secondary
         *        indexes (GSIs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits);

        /**
         * <p>
         * The maximum write capacity units that your account allows you to provision for a new table that you are
         * creating in this Region, including the write capacity units provisioned for its global secondary indexes
         * (GSIs).
         * </p>
         * 
         * @param tableMaxWriteCapacityUnits
         *        The maximum write capacity units that your account allows you to provision for a new table that you
         *        are creating in this Region, including the write capacity units provisioned for its global secondary
         *        indexes (GSIs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private Long accountMaxReadCapacityUnits;

        private Long accountMaxWriteCapacityUnits;

        private Long tableMaxReadCapacityUnits;

        private Long tableMaxWriteCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLimitsResponse model) {
            super(model);
            accountMaxReadCapacityUnits(model.accountMaxReadCapacityUnits);
            accountMaxWriteCapacityUnits(model.accountMaxWriteCapacityUnits);
            tableMaxReadCapacityUnits(model.tableMaxReadCapacityUnits);
            tableMaxWriteCapacityUnits(model.tableMaxWriteCapacityUnits);
        }

        public final Long getAccountMaxReadCapacityUnits() {
            return accountMaxReadCapacityUnits;
        }

        @Override
        public final Builder accountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits) {
            this.accountMaxReadCapacityUnits = accountMaxReadCapacityUnits;
            return this;
        }

        public final void setAccountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits) {
            this.accountMaxReadCapacityUnits = accountMaxReadCapacityUnits;
        }

        public final Long getAccountMaxWriteCapacityUnits() {
            return accountMaxWriteCapacityUnits;
        }

        @Override
        public final Builder accountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits) {
            this.accountMaxWriteCapacityUnits = accountMaxWriteCapacityUnits;
            return this;
        }

        public final void setAccountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits) {
            this.accountMaxWriteCapacityUnits = accountMaxWriteCapacityUnits;
        }

        public final Long getTableMaxReadCapacityUnits() {
            return tableMaxReadCapacityUnits;
        }

        @Override
        public final Builder tableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits) {
            this.tableMaxReadCapacityUnits = tableMaxReadCapacityUnits;
            return this;
        }

        public final void setTableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits) {
            this.tableMaxReadCapacityUnits = tableMaxReadCapacityUnits;
        }

        public final Long getTableMaxWriteCapacityUnits() {
            return tableMaxWriteCapacityUnits;
        }

        @Override
        public final Builder tableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits) {
            this.tableMaxWriteCapacityUnits = tableMaxWriteCapacityUnits;
            return this;
        }

        public final void setTableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits) {
            this.tableMaxWriteCapacityUnits = tableMaxWriteCapacityUnits;
        }

        @Override
        public DescribeLimitsResponse build() {
            return new DescribeLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
