/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * Determines the level of detail about provisioned throughput consumption that is returned in the response:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together
 * with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.
 * </p>
 * <p>
 * Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at
 * all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for
 * table(s).
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum ReturnConsumedCapacity {
    INDEXES("INDEXES"),

    TOTAL("TOTAL"),

    NONE("NONE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReturnConsumedCapacity(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ReturnConsumedCapacity corresponding to the value
     */
    public static ReturnConsumedCapacity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReturnConsumedCapacity.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ReturnConsumedCapacity}s
     */
    public static Set<ReturnConsumedCapacity> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
