/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CancellationReasonListCopier {
    static List<CancellationReason> copy(Collection<CancellationReason> cancellationReasonListParam) {
        if (cancellationReasonListParam == null || cancellationReasonListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<CancellationReason> cancellationReasonListParamCopy = new ArrayList<>(cancellationReasonListParam);
        return Collections.unmodifiableList(cancellationReasonListParamCopy);
    }

    static List<CancellationReason> copyFromBuilder(Collection<? extends CancellationReason.Builder> cancellationReasonListParam) {
        if (cancellationReasonListParam == null) {
            return null;
        }
        return copy(cancellationReasonListParam.stream().map(CancellationReason.Builder::build).collect(toList()));
    }
}
